/*
 * Decompiled with CFR 0.152.
 */
package io.lumigo.core.instrumentation.impl;

import com.amazonaws.Request;
import com.amazonaws.Response;
import io.lumigo.core.SpansContainer;
import io.lumigo.core.instrumentation.LumigoInstrumentationApi;
import io.lumigo.core.instrumentation.agent.Loader;
import io.lumigo.core.utils.LRUCache;
import net.bytebuddy.agent.builder.AgentBuilder;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import org.pmw.tinylog.Logger;

public class AmazonHttpClientInstrumentation
implements LumigoInstrumentationApi {
    @Override
    public ElementMatcher<TypeDescription> getTypeMatcher() {
        return ElementMatchers.named((String)"com.amazonaws.http.AmazonHttpClient");
    }

    @Override
    public AgentBuilder.Transformer.ForAdvice getTransformer() {
        return new AgentBuilder.Transformer.ForAdvice().include(new ClassLoader[]{Loader.class.getClassLoader()}).advice((ElementMatcher)ElementMatchers.isMethod().and((ElementMatcher)ElementMatchers.named((String)"execute")), AmazonHttpClientAdvice.class.getName());
    }

    public static class AmazonHttpClientAdvice {
        public static final SpansContainer spansContainer = SpansContainer.getInstance();
        public static final LRUCache<Integer, Boolean> handled = new LRUCache(1000);
        public static final LRUCache<Integer, Long> startTimeMap = new LRUCache(1000);

        @Advice.OnMethodEnter
        public static void methodEnter(@Advice.Argument(value=0) Request<?> request) {
            try {
                String patchedRoot = spansContainer.getPatchedRoot();
                request.getHeaders().put("X-Amzn-Trace-Id", patchedRoot);
                startTimeMap.put(request.hashCode(), System.currentTimeMillis());
            }
            catch (Exception e) {
                Logger.error((Throwable)e, (String)"Failed to send data on http requests");
            }
        }

        @Advice.OnMethodExit(onThrowable=Throwable.class, suppress=Throwable.class)
        public static void methodExit(@Advice.Argument(value=0) Request<?> request, @Advice.Return Response<?> response) {
            try {
                if (handled.get(request.hashCode()) == null) {
                    Logger.info((String)"Handling request {} from host {}", (Object[])new Object[]{request.hashCode(), request.getEndpoint()});
                    spansContainer.addHttpSpan((Long)startTimeMap.get(request.hashCode()), request, response);
                    handled.put(request.hashCode(), true);
                } else {
                    Logger.warn((String)"Already handle request {} for host {}", (Object[])new Object[]{request.hashCode(), request.getEndpoint().getHost()});
                }
            }
            catch (Throwable e) {
                Logger.error((Throwable)e, (String)"Failed to send data on http response");
            }
            finally {
                startTimeMap.remove(request.hashCode());
            }
        }
    }
}

