/*
 * Decompiled with CFR 0.152.
 */
package io.lumigo.core.instrumentation.impl;

import io.lumigo.core.SpansContainer;
import io.lumigo.core.configuration.Configuration;
import io.lumigo.core.instrumentation.LumigoInstrumentationApi;
import io.lumigo.core.instrumentation.agent.Loader;
import io.lumigo.core.utils.LRUCache;
import net.bytebuddy.agent.builder.AgentBuilder;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.pmw.tinylog.Logger;

public class ApacheHttpInstrumentation
implements LumigoInstrumentationApi {
    @Override
    public ElementMatcher<TypeDescription> getTypeMatcher() {
        return ElementMatchers.hasSuperType((ElementMatcher)ElementMatchers.named((String)"org.apache.http.client.HttpClient").and((ElementMatcher)ElementMatchers.isInterface()));
    }

    @Override
    public AgentBuilder.Transformer.ForAdvice getTransformer() {
        return new AgentBuilder.Transformer.ForAdvice().include(new ClassLoader[]{Loader.class.getClassLoader()}).advice((ElementMatcher)ElementMatchers.isMethod().and((ElementMatcher)ElementMatchers.named((String)"execute")).and((ElementMatcher)ElementMatchers.not((ElementMatcher)ElementMatchers.isAbstract()).and((ElementMatcher)ElementMatchers.takesArgument((int)0, (ElementMatcher)ElementMatchers.named((String)"org.apache.http.client.methods.HttpUriRequest")))), ApacheHttpAdvice.class.getName());
    }

    public static class ApacheHttpAdvice {
        public static final SpansContainer spansContainer = SpansContainer.getInstance();
        public static final LRUCache<Integer, Boolean> handled = new LRUCache(1000);
        public static final LRUCache<Integer, Long> startTimeMap = new LRUCache(1000);

        @Advice.OnMethodEnter
        public static void methodEnter(@Advice.Argument(value=0) HttpUriRequest request) {
            try {
                if (Configuration.getInstance().isLumigoHost(request.getURI().getHost())) {
                    Logger.debug((String)"Skip, internal lumigo reporter");
                    return;
                }
                if (Configuration.getInstance().isAwsHost(request.getURI().getHost())) {
                    Logger.debug((String)"Skip, aws api");
                    return;
                }
                startTimeMap.put(request.hashCode(), System.currentTimeMillis());
            }
            catch (Exception e) {
                Logger.error((Throwable)e);
            }
        }

        @Advice.OnMethodExit(onThrowable=Throwable.class, suppress=Throwable.class)
        public static void methodExit(@Advice.Argument(value=0) HttpUriRequest request, @Advice.Return Object result) {
            try {
                if (Configuration.getInstance().isLumigoHost(request.getURI().getHost())) {
                    Logger.debug((String)"Skip, internal lumigo reporter");
                    return;
                }
                if (Configuration.getInstance().isAwsHost(request.getURI().getHost())) {
                    Logger.debug((String)"Skip, aws api");
                    return;
                }
                if (handled.get(request.hashCode()) == null) {
                    Logger.debug((String)"Handling request {} from host {}", (Object[])new Object[]{request.hashCode(), request.getURI().getHost()});
                    if (result instanceof HttpResponse) {
                        spansContainer.addHttpSpan((Long)startTimeMap.get(request.hashCode()), request, (HttpResponse)result);
                        handled.put(request.hashCode(), true);
                    }
                } else {
                    Logger.warn((String)"Already handle request {} for host {}", (Object[])new Object[]{request.hashCode(), request.getURI().getHost()});
                }
            }
            catch (Throwable e) {
                Logger.error((Throwable)e, (String)"Failed to send data on http requests");
            }
        }
    }
}

