/*
 * Decompiled with CFR 0.152.
 */
package io.lumigo.core.parsers;

import io.lumigo.core.parsers.AwsParser;
import io.lumigo.core.parsers.DefaultParser;
import io.lumigo.core.parsers.DynamoDBParser;
import io.lumigo.core.parsers.KinesisParser;
import io.lumigo.core.parsers.SnsParser;
import io.lumigo.core.parsers.SqsParser;

public class AwsParserFactory {
    public static AwsParser getParser(String serviceName) {
        if (serviceName == null) {
            return new DefaultParser();
        }
        switch (serviceName) {
            case "AmazonSNS": {
                return new SnsParser();
            }
            case "AmazonSQS": {
                return new SqsParser();
            }
            case "AmazonKinesis": {
                return new KinesisParser();
            }
            case "AmazonDynamoDB": 
            case "AmazonDynamoDBv2": {
                return new DynamoDBParser();
            }
        }
        return new DefaultParser();
    }
}

