/*
 * Decompiled with CFR 0.152.
 */
package io.lumigo.core.parsers;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.services.dynamodbv2.model.BatchGetItemRequest;
import com.amazonaws.services.dynamodbv2.model.BatchWriteItemRequest;
import com.amazonaws.services.dynamodbv2.model.DeleteItemRequest;
import com.amazonaws.services.dynamodbv2.model.GetItemRequest;
import com.amazonaws.services.dynamodbv2.model.PutItemRequest;
import com.amazonaws.services.dynamodbv2.model.UpdateItemRequest;
import com.amazonaws.services.dynamodbv2.model.WriteRequest;
import io.lumigo.core.parsers.AwsParser;
import io.lumigo.core.utils.StringUtils;
import io.lumigo.models.HttpSpan;
import java.util.List;
import java.util.Map;
import org.pmw.tinylog.Logger;

public class DynamoDBParser
implements AwsParser {
    @Override
    public void parse(HttpSpan span, Request request, Response response) {
        try {
            String tableName;
            String messageId = this.extractMessageId(request.getOriginalRequest());
            if (messageId != null) {
                span.getInfo().setMessageId(messageId);
            }
            if ((tableName = this.extractTableName(request.getOriginalRequest())) != null) {
                span.getInfo().setResourceName(tableName);
            }
        }
        catch (Exception e) {
            Logger.error((Throwable)e, (String)"Failed to parse for DynamoDB request");
        }
    }

    private String extractMessageId(AmazonWebServiceRequest request) {
        if (request instanceof PutItemRequest) {
            return StringUtils.dynamodbItemToHash(((PutItemRequest)request).getItem());
        }
        if (request instanceof UpdateItemRequest) {
            return StringUtils.dynamodbItemToHash(((UpdateItemRequest)request).getKey());
        }
        if (request instanceof DeleteItemRequest) {
            return StringUtils.dynamodbItemToHash(((DeleteItemRequest)request).getKey());
        }
        if (request instanceof BatchWriteItemRequest) {
            Map requests = ((BatchWriteItemRequest)request).getRequestItems();
            WriteRequest firstRequest = (WriteRequest)((List)requests.entrySet().iterator().next().getValue()).get(0);
            if (firstRequest.getPutRequest() != null) {
                return StringUtils.dynamodbItemToHash(firstRequest.getPutRequest().getItem());
            }
            if (firstRequest.getDeleteRequest() != null) {
                return StringUtils.dynamodbItemToHash(firstRequest.getDeleteRequest().getKey());
            }
        }
        return null;
    }

    private String extractTableName(AmazonWebServiceRequest request) {
        if (request instanceof PutItemRequest) {
            return ((PutItemRequest)request).getTableName();
        }
        if (request instanceof UpdateItemRequest) {
            return ((UpdateItemRequest)request).getTableName();
        }
        if (request instanceof DeleteItemRequest) {
            return ((DeleteItemRequest)request).getTableName();
        }
        if (request instanceof BatchWriteItemRequest) {
            Map requests = ((BatchWriteItemRequest)request).getRequestItems();
            return (String)requests.entrySet().iterator().next().getKey();
        }
        if (request instanceof BatchGetItemRequest) {
            Map requests = ((BatchGetItemRequest)request).getRequestItems();
            return (String)requests.entrySet().iterator().next().getKey();
        }
        if (request instanceof GetItemRequest) {
            return ((GetItemRequest)request).getTableName();
        }
        return null;
    }
}

