/*
 * Decompiled with CFR 0.152.
 */
package io.lumigo.core.parsers;

import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.services.kinesis.model.PutRecordRequest;
import com.amazonaws.services.kinesis.model.PutRecordResult;
import com.amazonaws.services.kinesis.model.PutRecordsRequest;
import com.amazonaws.services.kinesis.model.PutRecordsResult;
import io.lumigo.core.parsers.AwsParser;
import io.lumigo.models.HttpSpan;
import java.util.LinkedList;
import java.util.List;
import org.pmw.tinylog.Logger;

public class KinesisParser
implements AwsParser {
    @Override
    public void parse(HttpSpan span, Request request, Response response) {
        try {
            List<String> messageIds;
            if (request.getOriginalRequest() instanceof PutRecordRequest) {
                span.getInfo().setResourceName(((PutRecordRequest)request.getOriginalRequest()).getStreamName());
            }
            if (request.getOriginalRequest() instanceof PutRecordsRequest) {
                span.getInfo().setResourceName(((PutRecordsRequest)request.getOriginalRequest()).getStreamName());
            }
            if ((messageIds = this.extractMessageIds(response.getAwsResponse())).size() > 0) {
                span.getInfo().setMessageIds(messageIds);
            }
        }
        catch (Exception e) {
            Logger.error((Throwable)e, (String)"Failed to extract parse for Kinesis request");
        }
    }

    private List<String> extractMessageIds(Object response) {
        LinkedList<String> result = new LinkedList<String>();
        if (response instanceof PutRecordsResult) {
            ((PutRecordsResult)response).getRecords().forEach(putRecordsResultEntry -> result.add(putRecordsResultEntry.getSequenceNumber()));
            return result;
        }
        if (response instanceof PutRecordResult) {
            result.add(((PutRecordResult)response).getSequenceNumber());
            return result;
        }
        Logger.error((String)"Failed to extract messageIds for Kinesis response");
        return result;
    }
}

