/*
 * Decompiled with CFR 0.152.
 */
package io.lumigo.core.parsers.event;

import com.amazonaws.services.lambda.runtime.events.APIGatewayProxyRequestEvent;
import com.amazonaws.services.lambda.runtime.events.SNSEvent;
import com.amazonaws.services.lambda.runtime.events.SQSEvent;
import io.lumigo.core.parsers.event.APIGWEventParser;
import io.lumigo.core.parsers.event.SnsEventParser;
import io.lumigo.core.parsers.event.SqsEventParser;
import org.pmw.tinylog.Logger;

public interface EventParserFactory {
    public static Object parseEvent(Object event) {
        try {
            if (event instanceof APIGatewayProxyRequestEvent) {
                return new APIGWEventParser().parse((APIGatewayProxyRequestEvent)event);
            }
            if (event instanceof SNSEvent) {
                return new SnsEventParser().parse((SNSEvent)event);
            }
            if (event instanceof SQSEvent) {
                return new SqsEventParser().parse((SQSEvent)event);
            }
            return event;
        }
        catch (Exception e) {
            Logger.error((Throwable)e, (String)"Fail to parse event");
            return event;
        }
    }
}

