/*
 * Decompiled with CFR 0.152.
 */
package io.lumigo.core.parsers.event;

import com.amazonaws.services.lambda.runtime.events.SNSEvent;
import io.lumigo.core.parsers.event.IEventParser;
import io.lumigo.core.parsers.event.SnsEvent;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;

public class SnsEventParser
implements IEventParser<SNSEvent> {
    @Override
    public Object parse(SNSEvent event) {
        LinkedList<SnsEvent.Record> records = new LinkedList<SnsEvent.Record>();
        for (SNSEvent.SNSRecord rec : event.getRecords()) {
            HashMap<String, SnsEvent.MessageAttribute> attributes = new HashMap<String, SnsEvent.MessageAttribute>();
            for (Map.Entry attributeEntry : rec.getSNS().getMessageAttributes().entrySet()) {
                attributes.put((String)attributeEntry.getKey(), SnsEvent.MessageAttribute.builder().type(((SNSEvent.MessageAttribute)attributeEntry.getValue()).getType()).value(((SNSEvent.MessageAttribute)attributeEntry.getValue()).getValue()).build());
            }
            records.add(SnsEvent.Record.builder().message(rec.getSNS().getMessage()).messageAttributes(attributes).messageId(rec.getSNS().getMessageId()).build());
        }
        return SnsEvent.builder().records(records).build();
    }
}

