/*
 * Decompiled with CFR 0.152.
 */
package io.lumigo.core.utils;

import java.util.Map;
import org.pmw.tinylog.Logger;

public class EnvUtil {
    public String getEnv(String key) {
        return System.getenv(key);
    }

    public Boolean getBooleanEnv(String key, Boolean dflt) {
        String value = this.getEnv(key);
        return value == null ? dflt.booleanValue() : "true".equalsIgnoreCase(value);
    }

    public Integer getIntegerEnv(String key, Integer dflt) {
        try {
            String value = this.getEnv(key);
            return Integer.valueOf(value);
        }
        catch (Exception ignored) {
            Logger.info((String)("No configuration to key " + key + ", use default " + dflt));
            return dflt;
        }
    }

    public String[] getStringArrayEnv(String key, String[] dflt) {
        String value = this.getEnv(key);
        if (value != null && !value.isEmpty()) {
            return value.split(",");
        }
        return dflt;
    }

    public Map<String, String> getEnv() {
        return System.getenv();
    }
}

