/*
 * Decompiled with CFR 0.152.
 */
package io.lumigo.handlers;

import com.amazonaws.services.lambda.runtime.Context;
import io.lumigo.core.SpansContainer;
import io.lumigo.core.configuration.Configuration;
import io.lumigo.core.instrumentation.agent.Installer;
import io.lumigo.core.network.Reporter;
import io.lumigo.core.utils.EnvUtil;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.function.Supplier;
import org.pmw.tinylog.Logger;

public class LumigoRequestExecutor {
    protected ExecutorService executorService = Executors.newSingleThreadExecutor();
    private static LumigoRequestExecutor instance = new LumigoRequestExecutor();
    private EnvUtil envUtil;
    private Reporter reporter;
    private SpansContainer spansContainer;

    public LumigoRequestExecutor() {
        try {
            this.envUtil = new EnvUtil();
            this.reporter = new Reporter();
            this.spansContainer = SpansContainer.getInstance();
        }
        catch (RuntimeException ex) {
            Logger.error((Throwable)ex, (String)"Failed to init LumigoRequestHandler");
        }
    }

    public static LumigoRequestExecutor getInstance() {
        return instance;
    }

    public static void init() {
        instance = new LumigoRequestExecutor();
    }

    public static <OUTPUT, INPUT> OUTPUT execute(INPUT input, Context context, Supplier<OUTPUT> handler) {
        return LumigoRequestExecutor.getInstance().executeInternal(input, context, handler);
    }

    private <OUTPUT, INPUT> OUTPUT executeInternal(INPUT input, Context context, Supplier<OUTPUT> handler) {
        if (Configuration.getInstance().isKillingSwitchActivated()) {
            return handler.get();
        }
        try {
            Logger.debug((String)"Start {} Lumigo tracer", (Object[])new Object[]{LumigoRequestExecutor.class.getName()});
            try {
                this.spansContainer.init(this.envUtil.getEnv(), this.reporter, context, input);
                Future<?> submit = this.executorService.submit(() -> Installer.install());
                this.spansContainer.start();
                submit.get();
                Logger.debug((String)"Finish sending start message and instrumentation");
            }
            catch (Throwable e) {
                Logger.error((Throwable)e, (String)"Failed to init span container");
            }
            OUTPUT response = handler.get();
            try {
                this.spansContainer.end(response);
            }
            catch (Throwable e) {
                Logger.error((Throwable)e, (String)"Failed to create end span");
            }
            return response;
        }
        catch (Throwable throwable) {
            try {
                Logger.debug((String)"Customer lambda had exception {}", (Object[])new Object[]{throwable.getClass().getName()});
                this.spansContainer.endWithException(throwable);
            }
            catch (Throwable ex) {
                Logger.error((Throwable)ex, (String)"Failed to create end span");
            }
            throw throwable;
        }
    }

    void setEnvUtil(EnvUtil envUtil) {
        this.envUtil = envUtil;
    }

    void setReporter(Reporter reporter) {
        this.reporter = reporter;
    }

    void setSpansContainer(SpansContainer spansContainer) {
        this.spansContainer = spansContainer;
    }
}

