/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runner;

import cucumber.api.event.Event;
import cucumber.api.event.EventHandler;
import cucumber.api.event.EventPublisher;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class AbstractEventPublisher
implements EventPublisher {
    protected Map<Class<? extends Event>, List<EventHandler>> handlers = new HashMap<Class<? extends Event>, List<EventHandler>>();

    AbstractEventPublisher() {
    }

    @Override
    public final <T extends Event> void registerHandlerFor(Class<T> eventType, EventHandler<T> handler) {
        if (this.handlers.containsKey(eventType)) {
            this.handlers.get(eventType).add(handler);
        } else {
            ArrayList<EventHandler<T>> list = new ArrayList<EventHandler<T>>();
            list.add(handler);
            this.handlers.put(eventType, list);
        }
    }

    @Override
    public final <T extends Event> void removeHandlerFor(Class<T> eventType, EventHandler<T> handler) {
        if (this.handlers.containsKey(eventType)) {
            this.handlers.get(eventType).remove(handler);
        }
    }

    protected void send(Event event) {
        if (this.handlers.containsKey(Event.class)) {
            for (EventHandler handler : this.handlers.get(Event.class)) {
                handler.receive(event);
            }
        }
        if (this.handlers.containsKey(event.getClass())) {
            for (EventHandler handler : this.handlers.get(event.getClass())) {
                handler.receive(event);
            }
        }
    }

    protected void sendAll(Iterable<Event> events) {
        for (Event event : events) {
            this.send(event);
        }
    }
}

