/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runner;

import cucumber.api.Argument;
import cucumber.api.TestCase;
import cucumber.runner.EventBus;
import cucumber.runner.HookTestStep;
import cucumber.runner.PickleStepDefinitionMatch;
import cucumber.runner.Scenario;
import cucumber.runner.TestStep;
import cucumber.runtime.DefinitionArgument;
import gherkin.pickles.PickleLocation;
import gherkin.pickles.PickleStep;
import java.util.Collections;
import java.util.List;

class PickleStepTestStep
extends TestStep
implements cucumber.api.PickleStepTestStep {
    private final String uri;
    private final PickleStep step;
    private final List<HookTestStep> afterStepHookSteps;
    private final List<HookTestStep> beforeStepHookSteps;
    private final PickleStepDefinitionMatch definitionMatch;

    PickleStepTestStep(String uri, PickleStep step, PickleStepDefinitionMatch definitionMatch) {
        this(uri, step, Collections.emptyList(), Collections.emptyList(), definitionMatch);
    }

    PickleStepTestStep(String uri, PickleStep step, List<HookTestStep> beforeStepHookSteps, List<HookTestStep> afterStepHookSteps, PickleStepDefinitionMatch definitionMatch) {
        super(definitionMatch);
        this.uri = uri;
        this.step = step;
        this.afterStepHookSteps = afterStepHookSteps;
        this.beforeStepHookSteps = beforeStepHookSteps;
        this.definitionMatch = definitionMatch;
    }

    @Override
    boolean run(TestCase testCase, EventBus bus, Scenario scenario, boolean skipSteps) {
        boolean skipNextStep = skipSteps;
        for (HookTestStep before : this.beforeStepHookSteps) {
            skipNextStep |= before.run(testCase, bus, scenario, skipSteps);
        }
        skipNextStep |= super.run(testCase, bus, scenario, skipNextStep);
        for (HookTestStep after : this.afterStepHookSteps) {
            skipNextStep |= after.run(testCase, bus, scenario, skipSteps);
        }
        return skipNextStep;
    }

    List<HookTestStep> getBeforeStepHookSteps() {
        return this.beforeStepHookSteps;
    }

    List<HookTestStep> getAfterStepHookSteps() {
        return this.afterStepHookSteps;
    }

    @Override
    public PickleStep getPickleStep() {
        return this.step;
    }

    @Override
    public String getStepLocation() {
        return this.uri + ":" + Integer.toString(this.getStepLine());
    }

    @Override
    public int getStepLine() {
        return ((PickleLocation)this.step.getLocations().get(this.step.getLocations().size() - 1)).getLine();
    }

    @Override
    public String getStepText() {
        return this.step.getText();
    }

    @Override
    public List<Argument> getDefinitionArgument() {
        return DefinitionArgument.createArguments(this.definitionMatch.getArguments());
    }

    @Override
    public List<gherkin.pickles.Argument> getStepArgument() {
        return this.step.getArgument();
    }

    @Override
    public String getPattern() {
        return this.definitionMatch.getPattern();
    }
}

