/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runtime.filter;

import gherkin.pickles.PickleTag;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

class TagExpressionOld {
    private final Map<String, Integer> limits = new HashMap<String, Integer>();
    private And and = new And();

    static boolean isOldTagExpression(String tagExpression) {
        if (tagExpression == null) {
            return false;
        }
        if (tagExpression.contains(",")) {
            System.err.println("WARNING: Found tags option '" + tagExpression + "'. Support for '@tag1,@tag2' will be removed from the next release of Cucumber-JVM. Please use '@tag or @tag2' instead");
        }
        if (tagExpression.contains("~")) {
            System.err.println("WARNING: Found tags option '" + tagExpression + "'. Support for '~@tag' will be removed from the next release of Cucumber-JVM. Please use 'not @tag' instead.");
        }
        return tagExpression.contains(",") || tagExpression.contains("~");
    }

    TagExpressionOld(List<String> tagExpressions) {
        for (String tagExpression : tagExpressions) {
            this.add(tagExpression.split("\\s*,\\s*"));
        }
    }

    boolean evaluate(Collection<PickleTag> tags) {
        return this.and.isEmpty() || this.and.eval(tags);
    }

    public Map<String, Integer> limits() {
        return this.limits;
    }

    public boolean isEmpty() {
        return this.and.isEmpty();
    }

    private void add(String[] tags) {
        Or or = new Or();
        for (String tag : tags) {
            boolean negation;
            if ((tag = tag.trim()).startsWith("~")) {
                tag = tag.substring(1);
                negation = true;
            } else {
                negation = false;
            }
            String[] tagAndLimit = tag.split(":");
            if (tagAndLimit.length == 2) {
                tag = tagAndLimit[0];
                int limit = Integer.parseInt(tagAndLimit[1]);
                if (this.limits.containsKey(tag) && this.limits.get(tag) != limit) {
                    throw new BadTagLimitException(tag, this.limits.get(tag), limit);
                }
                this.limits.put(tag, limit);
            }
            if (negation) {
                or.add(new Not(new TagExp(tag)));
                continue;
            }
            or.add(new TagExp(tag));
        }
        this.and.add(or);
    }

    private class BadTagLimitException
    extends RuntimeException {
        BadTagLimitException(String tag, int limitA, int limitB) {
            super("Inconsistent tag limits for " + tag + ": " + limitA + " and " + limitB);
        }
    }

    private class BadTagException
    extends RuntimeException {
        BadTagException(String tagName) {
            super("Bad tag: \"" + tagName + "\"");
        }
    }

    private class TagExp
    implements Expression {
        private final String tagName;

        TagExp(String tagName) {
            if (!tagName.startsWith("@")) {
                throw new BadTagException(tagName);
            }
            this.tagName = tagName;
        }

        @Override
        public boolean eval(Collection<PickleTag> tags) {
            for (PickleTag tag : tags) {
                if (!this.tagName.equals(tag.getName())) continue;
                return true;
            }
            return false;
        }
    }

    private class Or
    implements Expression {
        private List<Expression> expressions = new ArrayList<Expression>();

        private Or() {
        }

        public void add(Expression expression) {
            this.expressions.add(expression);
        }

        @Override
        public boolean eval(Collection<PickleTag> tags) {
            Expression expression;
            boolean result = false;
            Iterator<Expression> iterator = this.expressions.iterator();
            while (iterator.hasNext() && !(result = (expression = iterator.next()).eval(tags))) {
            }
            return result;
        }
    }

    private class And
    implements Expression {
        private List<Expression> expressions = new ArrayList<Expression>();

        private And() {
        }

        public void add(Expression expression) {
            this.expressions.add(expression);
        }

        @Override
        public boolean eval(Collection<PickleTag> tags) {
            Expression expression;
            boolean result = true;
            Iterator<Expression> iterator = this.expressions.iterator();
            while (iterator.hasNext() && (result = (expression = iterator.next()).eval(tags))) {
            }
            return result;
        }

        public boolean isEmpty() {
            return this.expressions.isEmpty();
        }
    }

    private class Not
    implements Expression {
        private final Expression expression;

        Not(Expression expression) {
            this.expression = expression;
        }

        @Override
        public boolean eval(Collection<PickleTag> tags) {
            return !this.expression.eval(tags);
        }
    }

    private static interface Expression {
        public boolean eval(Collection<PickleTag> var1);
    }
}

