/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runtime.io;

import cucumber.runtime.io.Resource;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;

class FileResource
implements Resource {
    private final File root;
    private final File file;
    private final boolean classpathFileResource;

    static FileResource createFileResource(File root, File file) {
        return new FileResource(root, file, false);
    }

    static FileResource createClasspathFileResource(File classpathRoot, File file) {
        return new FileResource(classpathRoot, file, true);
    }

    private FileResource(File root, File file, boolean classpathFileResource) {
        this.root = root;
        this.file = file;
        this.classpathFileResource = classpathFileResource;
        if (!file.getAbsolutePath().startsWith(root.getAbsolutePath())) {
            throw new IllegalArgumentException(file.getAbsolutePath() + " is not a parent of " + root.getAbsolutePath());
        }
    }

    @Override
    public URI getPath() {
        if (this.classpathFileResource) {
            return FileResource.createURI("classpath", this.getRelativePath());
        }
        if (this.root.equals(this.file)) {
            return this.file.toURI();
        }
        return FileResource.createURI("file", this.getRelativePath());
    }

    private static URI createURI(String classpathScheme, String ssp) {
        try {
            return new URI(classpathScheme, ssp, null);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private String getRelativePath() {
        URI relativeUri = this.root.toURI().relativize(this.file.toURI());
        return relativeUri.getSchemeSpecificPart();
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return new FileInputStream(this.file);
    }
}

