/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runtime.junit;

import cucumber.api.Result;
import cucumber.api.TestCase;
import cucumber.runner.EventBus;
import cucumber.runtime.junit.FeatureRunner;
import io.magentys.cinnamon.cucumber.events.AfterHooksFinishedEvent;
import io.magentys.cinnamon.cucumber.events.CucumberFinishedEvent;
import io.magentys.cinnamon.cucumber.events.ScenarioFinishedEvent;
import io.magentys.cinnamon.cucumber.events.StepFinishedEvent;
import io.magentys.cinnamon.eventbus.EventBusContainer;
import java.util.ArrayList;
import java.util.List;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.NoAspectBoundException;
import org.aspectj.lang.annotation.After;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;

@Aspect
public class CucumberAspect {
    private static final ThreadLocal<String> featureName = new ThreadLocal();
    private static final ThreadLocal<List<Result>> results = new ThreadLocal();
    private static final ThreadLocal<EventBus> bus = new ThreadLocal();
    private static final ThreadLocal<TestCase> testCase = new ThreadLocal();
    private static /* synthetic */ Throwable ajc$initFailureCause;
    public static final /* synthetic */ CucumberAspect ajc$perSingletonInstance;

    static {
        try {
            CucumberAspect.ajc$perSingletonInstance = new CucumberAspect();
        }
        catch (Throwable throwable) {
            ajc$initFailureCause = throwable;
        }
    }

    @Pointcut(value="within(org.junit.runners.ParentRunner+) && execution(* run(..))")
    public /* synthetic */ void runCucumber() {
    }

    @Pointcut(value="execution(public * cucumber.runtime.junit.FeatureRunner.run(..))")
    public /* synthetic */ void runFeature() {
    }

    @Pointcut(value="execution(private * cucumber.runner.Runner.buildBackendWorlds(..))")
    public /* synthetic */ void buildBackendWorlds() {
    }

    @Pointcut(value="execution(public * cucumber.runner.Runner.getBus(..))")
    public /* synthetic */ void getBus() {
    }

    @Pointcut(value="execution(private * cucumber.runner.Runner.createTestCaseForPickle(..))")
    public /* synthetic */ void createTestCaseForPickle() {
    }

    @Pointcut(value="execution(* cucumber.runner.Scenario.add(..))")
    public /* synthetic */ void addResult() {
    }

    @Pointcut(value="execution(* cucumber.runner.TestCase.run(..))")
    public /* synthetic */ void runAfterHooks() {
    }

    @Pointcut(value="execution(private void cucumber.runner.Runner.disposeBackendWorlds(..))")
    public /* synthetic */ void disposeBackendWorlds() {
    }

    @Before(value="runFeature()")
    public void beforeRunFeature(JoinPoint joinPoint) {
        FeatureRunner featureRunner = (FeatureRunner)((Object)joinPoint.getTarget());
        featureName.set(featureRunner.getName());
    }

    @After(value="buildBackendWorlds()")
    public void afterBuildBackendWorlds() {
        results.set(new ArrayList());
    }

    @AfterReturning(pointcut="getBus()", returning="bus")
    public void afterReturningBus(EventBus bus) {
        CucumberAspect.bus.set(bus);
    }

    @AfterReturning(pointcut="createTestCaseForPickle()", returning="testCase")
    public void afterReturningTestCase(TestCase testCase) {
        CucumberAspect.testCase.set(testCase);
    }

    @After(value="addResult() && args(result,..)")
    public void afterAddResult(Result result) {
        results.get().add(result);
        EventBusContainer.getEventBus().post((Object)new StepFinishedEvent(bus.get(), testCase.get(), result));
    }

    @After(value="runAfterHooks()")
    public void afterRunAfterHooks() {
        EventBusContainer.getEventBus().post((Object)new AfterHooksFinishedEvent());
    }

    @After(value="disposeBackendWorlds()")
    public void afterDisposeBackendWorlds() {
        EventBusContainer.getEventBus().post((Object)new ScenarioFinishedEvent(results.get()));
    }

    @After(value="runCucumber()")
    public void afterRunCucumber() {
        try {
            EventBusContainer.getEventBus().post((Object)new CucumberFinishedEvent());
        }
        finally {
            bus.remove();
            testCase.remove();
            results.remove();
            featureName.remove();
        }
    }

    public static CucumberAspect aspectOf() {
        if (ajc$perSingletonInstance == null) {
            throw new NoAspectBoundException("cucumber.runtime.junit.CucumberAspect", ajc$initFailureCause);
        }
        return ajc$perSingletonInstance;
    }

    public static boolean hasAspect() {
        return ajc$perSingletonInstance != null;
    }
}

