/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runtime.junit;

import cucumber.runner.Runner;
import cucumber.runner.RunnerSupplier;
import cucumber.runtime.junit.CucumberAspect;
import cucumber.runtime.junit.JUnitOptions;
import cucumber.runtime.junit.JUnitReporter;
import gherkin.events.PickleEvent;
import gherkin.pickles.PickleLocation;
import gherkin.pickles.PickleStep;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.junit.runner.Description;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.ParentRunner;
import org.junit.runners.model.InitializationError;

class PickleRunners {
    PickleRunners() {
    }

    static PickleRunner withStepDescriptions(RunnerSupplier runnerSupplier, PickleEvent pickleEvent, JUnitOptions jUnitOptions) throws InitializationError {
        return new WithStepDescriptions(runnerSupplier, pickleEvent, jUnitOptions);
    }

    static PickleRunner withNoStepDescriptions(String featureName, RunnerSupplier runnerSupplier, PickleEvent pickleEvent, JUnitOptions jUnitOptions) {
        return new NoStepDescriptions(featureName, runnerSupplier, pickleEvent, jUnitOptions);
    }

    private static String getPickleName(PickleEvent pickleEvent, boolean useFilenameCompatibleNames) {
        String name = pickleEvent.pickle.getName();
        return PickleRunners.createName(name, useFilenameCompatibleNames);
    }

    private static String createName(String name, boolean useFilenameCompatibleNames) {
        if (name.isEmpty()) {
            return "EMPTY_NAME";
        }
        if (useFilenameCompatibleNames) {
            return PickleRunners.makeNameFilenameCompatible(name);
        }
        return name;
    }

    private static String makeNameFilenameCompatible(String name) {
        return name.replaceAll("[^A-Za-z0-9_]", "_");
    }

    private static final class PickleStepId
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final String uri;
        private final int pickleLine;
        private int pickleStepLine;

        PickleStepId(PickleEvent pickleEvent, PickleStep pickleStep) {
            this.uri = pickleEvent.uri;
            this.pickleLine = ((PickleLocation)pickleEvent.pickle.getLocations().get(0)).getLine();
            List stepLocations = pickleStep.getLocations();
            this.pickleStepLine = ((PickleLocation)stepLocations.get(stepLocations.size() - 1)).getLine();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PickleStepId that = (PickleStepId)o;
            return this.pickleLine == that.pickleLine && this.pickleStepLine == that.pickleStepLine && this.uri.equals(that.uri);
        }

        public int hashCode() {
            int result = this.pickleLine;
            result = 31 * result + this.uri.hashCode();
            result = 31 * result + this.pickleStepLine;
            return result;
        }

        public String toString() {
            return this.uri + ":" + this.pickleLine + ":" + this.pickleStepLine;
        }
    }

    static final class PickleId
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final String uri;
        private int pickleLine;

        PickleId(String uri, int pickleLine) {
            this.uri = uri;
            this.pickleLine = pickleLine;
        }

        PickleId(PickleEvent pickleEvent) {
            this(pickleEvent.uri, ((PickleLocation)pickleEvent.pickle.getLocations().get(0)).getLine());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PickleId that = (PickleId)o;
            return this.pickleLine == that.pickleLine && this.uri.equals(that.uri);
        }

        public int hashCode() {
            int result = this.uri.hashCode();
            result = 31 * result + this.pickleLine;
            return result;
        }

        public String toString() {
            return this.uri + ":" + this.pickleLine;
        }
    }

    static final class NoStepDescriptions
    implements PickleRunner {
        private final String featureName;
        private final RunnerSupplier runnerSupplier;
        private final PickleEvent pickleEvent;
        private final JUnitOptions jUnitOptions;
        private Description description;

        NoStepDescriptions(String featureName, RunnerSupplier runnerSupplier, PickleEvent pickleEvent, JUnitOptions jUnitOptions) {
            this.featureName = featureName;
            this.runnerSupplier = runnerSupplier;
            this.pickleEvent = pickleEvent;
            this.jUnitOptions = jUnitOptions;
        }

        @Override
        public Description getDescription() {
            if (this.description == null) {
                String className = PickleRunners.createName(this.featureName, this.jUnitOptions.filenameCompatibleNames());
                String name = PickleRunners.getPickleName(this.pickleEvent, this.jUnitOptions.filenameCompatibleNames());
                this.description = Description.createTestDescription((String)className, (String)name, (Serializable)new PickleId(this.pickleEvent));
            }
            return this.description;
        }

        @Override
        public Description describeChild(PickleStep step) {
            throw new UnsupportedOperationException("This pickle runner does not wish to describe its children");
        }

        @Override
        public void run(RunNotifier notifier) {
            Runner runner = this.runnerSupplier.get();
            JUnitReporter jUnitReporter = new JUnitReporter(runner.getBus(), this.jUnitOptions);
            jUnitReporter.startExecutionUnit(this, notifier);
            runner.runPickle(this.pickleEvent);
            jUnitReporter.finishExecutionUnit();
        }
    }

    static class WithStepDescriptions
    extends ParentRunner<PickleStep>
    implements PickleRunner {
        private final RunnerSupplier runnerSupplier;
        private final PickleEvent pickleEvent;
        private final JUnitOptions jUnitOptions;
        private final Map<PickleStep, Description> stepDescriptions = new HashMap<PickleStep, Description>();
        private Description description;

        WithStepDescriptions(RunnerSupplier runnerSupplier, PickleEvent pickleEvent, JUnitOptions jUnitOptions) throws InitializationError {
            super(null);
            this.runnerSupplier = runnerSupplier;
            this.pickleEvent = pickleEvent;
            this.jUnitOptions = jUnitOptions;
        }

        protected List<PickleStep> getChildren() {
            return this.pickleEvent.pickle.getSteps();
        }

        public String getName() {
            return PickleRunners.getPickleName(this.pickleEvent, this.jUnitOptions.filenameCompatibleNames());
        }

        @Override
        public Description getDescription() {
            if (this.description == null) {
                this.description = Description.createSuiteDescription((String)this.getName(), (Serializable)new PickleId(this.pickleEvent), (Annotation[])new Annotation[0]);
                for (PickleStep step : this.getChildren()) {
                    this.description.addChild(this.describeChild(step));
                }
            }
            return this.description;
        }

        @Override
        public Description describeChild(PickleStep step) {
            Description description = this.stepDescriptions.get(step);
            if (description == null) {
                String testName = this.jUnitOptions.filenameCompatibleNames() ? PickleRunners.makeNameFilenameCompatible(step.getText()) : step.getText();
                description = Description.createTestDescription((String)this.getName(), (String)testName, (Serializable)new PickleStepId(this.pickleEvent, step));
                this.stepDescriptions.put(step, description);
            }
            return description;
        }

        @Override
        public void run(RunNotifier notifier) {
            try {
                Runner runner = this.runnerSupplier.get();
                JUnitReporter jUnitReporter = new JUnitReporter(runner.getBus(), this.jUnitOptions);
                jUnitReporter.startExecutionUnit(this, notifier);
                runner.runPickle(this.pickleEvent);
                jUnitReporter.finishExecutionUnit();
            }
            finally {
                CucumberAspect.aspectOf().afterRunCucumber();
            }
        }

        protected void runChild(PickleStep step, RunNotifier notifier) {
            throw new UnsupportedOperationException();
        }
    }

    static interface PickleRunner {
        public void run(RunNotifier var1);

        public Description getDescription();

        public Description describeChild(PickleStep var1);
    }
}

