/*
 * Decompiled with CFR 0.152.
 */
package io.magentys.cinnamon.cucumber.events;

import cucumber.api.Result;
import io.magentys.cinnamon.events.TestCaseFinishedEvent;
import java.util.Arrays;
import java.util.List;

public class ScenarioFinishedEvent
implements TestCaseFinishedEvent {
    private static final List<Result.Type> SEVERITY = Arrays.asList(Result.Type.PASSED, Result.Type.SKIPPED, Result.Type.PENDING, Result.Type.UNDEFINED, Result.Type.FAILED);
    private final List<Result> results;

    public ScenarioFinishedEvent(List<Result> results) {
        this.results = results;
    }

    public boolean isFailed() {
        return "failed".equals(this.getStatus());
    }

    public String getStatus() {
        int pos = 0;
        for (Result result : this.results) {
            pos = Math.max(pos, SEVERITY.indexOf((Object)result.getStatus()));
        }
        return SEVERITY.get(pos).lowerCaseName();
    }
}

