/*
 * Decompiled with CFR 0.152.
 */
package io.magentys.cinnamon.cucumber.events;

import cucumber.api.Result;
import cucumber.api.TestCase;
import cucumber.api.event.EmbedEvent;
import cucumber.runner.EventBus;
import io.magentys.cinnamon.events.Attachment;
import io.magentys.cinnamon.events.TestStepFinishedEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StepFinishedEvent
implements TestStepFinishedEvent {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final EventBus bus;
    private final TestCase testCase;
    private final Result result;

    public StepFinishedEvent(EventBus bus, TestCase testCase, Result result) {
        this.bus = bus;
        this.testCase = testCase;
        this.result = result;
    }

    public boolean isFailed() {
        return "failed".equals(this.getStatus());
    }

    public String getStatus() {
        return this.result.getStatus().lowerCaseName();
    }

    public void attach(Attachment attachment) {
        if (this.bus != null) {
            this.logger.debug("Firing embed event for scenario: " + this.testCase.getName());
            this.bus.send(new EmbedEvent(this.bus.getTime(), this.testCase, attachment.getBytes(), attachment.getMimeType()));
        }
    }
}

