/*
 * Decompiled with CFR 0.152.
 */
package io.mailtrap;

import jakarta.validation.ConstraintViolation;
import jakarta.validation.Validator;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class CustomValidator {
    private final Validator validator;

    public CustomValidator(Validator validator) {
        this.validator = validator;
    }

    public <T> Map<String, String> validate(T objectToValidate) {
        Set violations = this.validator.validate(objectToValidate, new Class[0]);
        HashMap<String, String> errors = new HashMap<String, String>();
        for (ConstraintViolation violation : violations) {
            errors.put(violation.getPropertyPath().toString(), violation.getMessage());
        }
        return errors;
    }

    public <T> String validateAndGetViolationsAsString(T objectToValidate) {
        return this.validate(objectToValidate).entrySet().stream().map(violation -> (String)violation.getKey() + "=" + (String)violation.getValue()).collect(Collectors.joining("; "));
    }
}

