/*
 * Decompiled with CFR 0.152.
 */
package io.mailtrap.api.accountaccesses;

import io.mailtrap.api.accountaccesses.AccountAccesses;
import io.mailtrap.api.apiresource.ApiResource;
import io.mailtrap.config.MailtrapConfig;
import io.mailtrap.http.RequestData;
import io.mailtrap.model.request.accountaccesses.ListAccountAccessQueryParams;
import io.mailtrap.model.response.accountaccesses.AccountAccessResponse;
import io.mailtrap.model.response.accountaccesses.RemoveAccountAccessResponse;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.NonNull;

public class AccountAccessesImpl
extends ApiResource
implements AccountAccesses {
    public AccountAccessesImpl(MailtrapConfig config) {
        super(config);
        this.apiHost = "https://mailtrap.io";
    }

    @Override
    public List<AccountAccessResponse> listUserAndInviteAccountAccesses(long accountId, @NonNull ListAccountAccessQueryParams params) {
        if (params == null) {
            throw new NullPointerException("params is marked non-null but is null");
        }
        Map queryParams = RequestData.buildQueryParams(RequestData.entry("domain_uuids", Optional.ofNullable(params.getDomainUuids())), RequestData.entry("inbox_ids", Optional.ofNullable(params.getInboxIds())), RequestData.entry("project_ids", Optional.ofNullable(params.getProjectIds())));
        return this.httpClient.getList(String.format(this.apiHost + "/api/accounts/%s/account_accesses", accountId), new RequestData(queryParams), AccountAccessResponse.class);
    }

    @Override
    public RemoveAccountAccessResponse removeAccountAccess(long accountAccessId, long accountId) {
        return this.httpClient.delete(String.format(this.apiHost + "/api/accounts/%s/account_accesses/%s", accountId, accountAccessId), new RequestData(), RemoveAccountAccessResponse.class);
    }
}

