/*
 * Decompiled with CFR 0.152.
 */
package io.mailtrap.api.apiresource;

import io.mailtrap.CustomValidator;
import io.mailtrap.api.apiresource.ApiResourceWithValidation;
import io.mailtrap.config.MailtrapConfig;
import io.mailtrap.exception.InvalidRequestBodyException;
import io.mailtrap.model.request.emails.MailtrapMail;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;

public abstract class SendApiResource
extends ApiResourceWithValidation {
    protected SendApiResource(MailtrapConfig config, CustomValidator customValidator) {
        super(config, customValidator);
    }

    protected void validateRequestBodyOrThrowException(MailtrapMail mail) throws InvalidRequestBodyException {
        boolean isSubjectTextHtmlEmpty;
        if (mail == null) {
            throw new InvalidRequestBodyException("Mail must not be null");
        }
        boolean bl = isSubjectTextHtmlEmpty = StringUtils.isEmpty((CharSequence)mail.getSubject()) && StringUtils.isEmpty((CharSequence)mail.getText()) && StringUtils.isEmpty((CharSequence)mail.getHtml());
        if (StringUtils.isEmpty((CharSequence)mail.getTemplateUuid())) {
            this.validateWithoutTemplate(mail, isSubjectTextHtmlEmpty);
        } else {
            this.validateWithTemplate(mail);
        }
        this.validateRequestBodyAndThrowException(mail);
    }

    private void validateWithoutTemplate(MailtrapMail mail, boolean isSubjectTextHtmlEmpty) throws InvalidRequestBodyException {
        if (isSubjectTextHtmlEmpty) {
            throw new InvalidRequestBodyException("Mail must have subject and either text or html when templateUuid is not provided");
        }
        if (MapUtils.isNotEmpty(mail.getTemplateVariables())) {
            throw new InvalidRequestBodyException("Mail templateVariables must only be used with templateUuid");
        }
        if (StringUtils.isEmpty((CharSequence)mail.getSubject())) {
            throw new InvalidRequestBodyException("Subject must not be null or empty");
        }
    }

    private void validateWithTemplate(MailtrapMail mail) throws InvalidRequestBodyException {
        if (StringUtils.isNotEmpty((CharSequence)mail.getText()) || StringUtils.isNotEmpty((CharSequence)mail.getHtml()) || StringUtils.isNotEmpty((CharSequence)mail.getSubject())) {
            throw new InvalidRequestBodyException("When templateUuid is used, subject, text, and html must not be used");
        }
    }
}

