/*
 * Decompiled with CFR 0.152.
 */
package io.mailtrap.api.attachments;

import io.mailtrap.api.apiresource.ApiResource;
import io.mailtrap.api.attachments.Attachments;
import io.mailtrap.config.MailtrapConfig;
import io.mailtrap.http.RequestData;
import io.mailtrap.model.response.attachment.AttachmentResponse;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class AttachmentsImpl
extends ApiResource
implements Attachments {
    public AttachmentsImpl(MailtrapConfig config) {
        super(config);
        this.apiHost = "https://mailtrap.io";
    }

    @Override
    public AttachmentResponse getSingleAttachment(long accountId, long inboxId, long messageId, long attachmentId) {
        return this.httpClient.get(String.format(this.apiHost + "/api/accounts/%s/inboxes/%s/messages/%s/attachments/%s", accountId, inboxId, messageId, attachmentId), new RequestData(), AttachmentResponse.class);
    }

    @Override
    public List<AttachmentResponse> getAttachments(long accountId, long inboxId, long messageId, String attachmentType) {
        Map queryParams = RequestData.buildQueryParams(RequestData.entry("attachment_type", Optional.ofNullable(attachmentType)));
        return this.httpClient.getList(String.format(this.apiHost + "/api/accounts/%s/inboxes/%s/messages/%s/attachments", accountId, inboxId, messageId), new RequestData(queryParams), AttachmentResponse.class);
    }
}

