/*
 * Decompiled with CFR 0.152.
 */
package io.mailtrap.api.inboxes;

import io.mailtrap.CustomValidator;
import io.mailtrap.api.apiresource.ApiResourceWithValidation;
import io.mailtrap.api.inboxes.Inboxes;
import io.mailtrap.config.MailtrapConfig;
import io.mailtrap.http.RequestData;
import io.mailtrap.model.request.inboxes.CreateInboxRequest;
import io.mailtrap.model.request.inboxes.UpdateInboxRequest;
import io.mailtrap.model.response.inboxes.InboxResponse;
import java.util.List;

public class InboxesImpl
extends ApiResourceWithValidation
implements Inboxes {
    public InboxesImpl(MailtrapConfig config, CustomValidator validator) {
        super(config, validator);
        this.apiHost = "https://mailtrap.io";
    }

    @Override
    public InboxResponse createInbox(long accountId, long projectId, CreateInboxRequest request) {
        this.validateRequestBodyAndThrowException(request);
        return this.httpClient.post(String.format(this.apiHost + "/api/accounts/%s/projects/%s/inboxes", accountId, projectId), request, new RequestData(), InboxResponse.class);
    }

    @Override
    public InboxResponse getInboxAttributes(long accountId, long inboxId) {
        return this.httpClient.get(String.format(this.apiHost + "/api/accounts/%s/inboxes/%s", accountId, inboxId), new RequestData(), InboxResponse.class);
    }

    @Override
    public InboxResponse deleteInbox(long accountId, long inboxId) {
        return this.httpClient.delete(String.format(this.apiHost + "/api/accounts/%s/inboxes/%s", accountId, inboxId), new RequestData(), InboxResponse.class);
    }

    @Override
    public InboxResponse updateInbox(long accountId, long inboxId, UpdateInboxRequest request) {
        this.validateRequestBodyAndThrowException(request);
        return this.httpClient.patch(String.format(this.apiHost + "/api/accounts/%s/inboxes/%s", accountId, inboxId), request, new RequestData(), InboxResponse.class);
    }

    @Override
    public InboxResponse cleanInbox(long accountId, long inboxId) {
        return this.httpClient.patch(String.format(this.apiHost + "/api/accounts/%s/inboxes/%s/clean", accountId, inboxId), null, new RequestData(), InboxResponse.class);
    }

    @Override
    public InboxResponse markAsRead(long accountId, long inboxId) {
        return this.httpClient.patch(String.format(this.apiHost + "/api/accounts/%s/inboxes/%s/all_read", accountId, inboxId), null, new RequestData(), InboxResponse.class);
    }

    @Override
    public InboxResponse resetCredentials(long accountId, long inboxId) {
        return this.httpClient.patch(String.format(this.apiHost + "/api/accounts/%s/inboxes/%s/reset_credentials", accountId, inboxId), null, new RequestData(), InboxResponse.class);
    }

    @Override
    public InboxResponse enableEmailAddress(long accountId, long inboxId) {
        return this.httpClient.patch(String.format(this.apiHost + "/api/accounts/%s/inboxes/%s/toggle_email_username", accountId, inboxId), null, new RequestData(), InboxResponse.class);
    }

    @Override
    public InboxResponse resetEmailAddresses(long accountId, long inboxId) {
        return this.httpClient.patch(String.format(this.apiHost + "/api/accounts/%s/inboxes/%s/reset_email_username", accountId, inboxId), null, new RequestData(), InboxResponse.class);
    }

    @Override
    public List<InboxResponse> getInboxes(long accountId) {
        return this.httpClient.getList(String.format(this.apiHost + "/api/accounts/%s/inboxes", accountId), new RequestData(), InboxResponse.class);
    }
}

