/*
 * Decompiled with CFR 0.152.
 */
package io.mailtrap.api.messages;

import io.mailtrap.api.apiresource.ApiResource;
import io.mailtrap.api.messages.Messages;
import io.mailtrap.config.MailtrapConfig;
import io.mailtrap.http.RequestData;
import io.mailtrap.model.request.accountaccesses.ListMessagesQueryParams;
import io.mailtrap.model.request.messages.ForwardMessageRequest;
import io.mailtrap.model.request.messages.UpdateMessageRequest;
import io.mailtrap.model.response.messages.ForwardMessageResponse;
import io.mailtrap.model.response.messages.MessageHeadersResponse;
import io.mailtrap.model.response.messages.MessageHtmlAnalysisResponse;
import io.mailtrap.model.response.messages.MessageResponse;
import io.mailtrap.model.response.messages.MessageSpamScoreResponse;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.NonNull;

public class MessagesImpl
extends ApiResource
implements Messages {
    public MessagesImpl(MailtrapConfig config) {
        super(config);
        this.apiHost = "https://mailtrap.io";
    }

    @Override
    public MessageResponse getMessage(long accountId, long inboxId, long messageId) {
        return this.httpClient.get(String.format(this.apiHost + "/api/accounts/%s/inboxes/%s/messages/%s", accountId, inboxId, messageId), new RequestData(), MessageResponse.class);
    }

    @Override
    public MessageResponse updateMessage(long accountId, long inboxId, long messageId, UpdateMessageRequest request) {
        return this.httpClient.patch(String.format(this.apiHost + "/api/accounts/%s/inboxes/%s/messages/%s", accountId, inboxId, messageId), request, new RequestData(), MessageResponse.class);
    }

    @Override
    public MessageResponse deleteMessage(long accountId, long inboxId, long messageId) {
        return this.httpClient.delete(String.format(this.apiHost + "/api/accounts/%s/inboxes/%s/messages/%s", accountId, inboxId, messageId), new RequestData(), MessageResponse.class);
    }

    @Override
    public List<MessageResponse> getMessages(long accountId, long inboxId, @NonNull ListMessagesQueryParams listMessagesQueryParams) {
        if (listMessagesQueryParams == null) {
            throw new NullPointerException("listMessagesQueryParams is marked non-null but is null");
        }
        Map queryParams = RequestData.buildQueryParams(RequestData.entry("last_id", Optional.ofNullable(listMessagesQueryParams.getLastId())), RequestData.entry("page", Optional.ofNullable(listMessagesQueryParams.getPage())), RequestData.entry("search", Optional.ofNullable(listMessagesQueryParams.getSearch())));
        return this.httpClient.getList(String.format(this.apiHost + "/api/accounts/%s/inboxes/%s/messages", accountId, inboxId), new RequestData(queryParams), MessageResponse.class);
    }

    @Override
    public ForwardMessageResponse forwardMessage(long accountId, long inboxId, long messageId, ForwardMessageRequest request) {
        return this.httpClient.post(String.format(this.apiHost + "/api/accounts/%s/inboxes/%s/messages/%s/forward", accountId, inboxId, messageId), request, new RequestData(), ForwardMessageResponse.class);
    }

    @Override
    public MessageSpamScoreResponse getSpamScore(long accountId, long inboxId, long messageId) {
        return this.httpClient.get(String.format(this.apiHost + "/api/accounts/%s/inboxes/%s/messages/%s/spam_report", accountId, inboxId, messageId), new RequestData(), MessageSpamScoreResponse.class);
    }

    @Override
    public MessageHtmlAnalysisResponse getMessageHtmlAnalysis(long accountId, long inboxId, long messageId) {
        return this.httpClient.get(String.format(this.apiHost + "/api/accounts/%s/inboxes/%s/messages/%s/analyze", accountId, inboxId, messageId), new RequestData(), MessageHtmlAnalysisResponse.class);
    }

    @Override
    public String getTextMessage(long accountId, long inboxId, long messageId) {
        return this.httpClient.get(String.format(this.apiHost + "/api/accounts/%s/inboxes/%s/messages/%s/body.txt", accountId, inboxId, messageId), new RequestData(), String.class);
    }

    @Override
    public String getRawMessage(long accountId, long inboxId, long messageId) {
        return this.httpClient.get(String.format(this.apiHost + "/api/accounts/%s/inboxes/%s/messages/%s/body.raw", accountId, inboxId, messageId), new RequestData(), String.class);
    }

    @Override
    public String getMessageSource(long accountId, long inboxId, long messageId) {
        return this.httpClient.get(String.format(this.apiHost + "/api/accounts/%s/inboxes/%s/messages/%s/body.htmlsource", accountId, inboxId, messageId), new RequestData(), String.class);
    }

    @Override
    public String getHtmlMessage(long accountId, long inboxId, long messageId) {
        return this.httpClient.get(String.format(this.apiHost + "/api/accounts/%s/inboxes/%s/messages/%s/body.html", accountId, inboxId, messageId), new RequestData(), String.class);
    }

    @Override
    public String getMessageAsEml(long accountId, long inboxId, long messageId) {
        return this.httpClient.get(String.format(this.apiHost + "/api/accounts/%s/inboxes/%s/messages/%s/body.eml", accountId, inboxId, messageId), new RequestData(), String.class);
    }

    @Override
    public MessageHeadersResponse getMailHeaders(long accountId, long inboxId, long messageId) {
        return this.httpClient.get(String.format(this.apiHost + "/api/accounts/%s/inboxes/%s/messages/%s/mail_headers", accountId, inboxId, messageId), new RequestData(), MessageHeadersResponse.class);
    }
}

