/*
 * Decompiled with CFR 0.152.
 */
package io.mailtrap.api.projects;

import io.mailtrap.CustomValidator;
import io.mailtrap.api.apiresource.ApiResourceWithValidation;
import io.mailtrap.api.projects.Projects;
import io.mailtrap.config.MailtrapConfig;
import io.mailtrap.http.RequestData;
import io.mailtrap.model.request.projects.CreateUpdateProjectRequest;
import io.mailtrap.model.response.projects.DeleteProjectResponse;
import io.mailtrap.model.response.projects.ProjectsResponse;
import java.util.List;

public class ProjectsImpl
extends ApiResourceWithValidation
implements Projects {
    public ProjectsImpl(MailtrapConfig config, CustomValidator customValidator) {
        super(config, customValidator);
        this.apiHost = "https://mailtrap.io";
    }

    @Override
    public ProjectsResponse createProject(long accountId, CreateUpdateProjectRequest request) {
        this.validateRequestBodyAndThrowException(request);
        return this.httpClient.post(String.format(this.apiHost + "/api/accounts/%s/projects", accountId), request, new RequestData(), ProjectsResponse.class);
    }

    @Override
    public List<ProjectsResponse> getProjects(long accountId) {
        return this.httpClient.getList(String.format(this.apiHost + "/api/accounts/%s/projects", accountId), new RequestData(), ProjectsResponse.class);
    }

    @Override
    public ProjectsResponse getProject(long accountId, long projectId) {
        return this.httpClient.get(String.format(this.apiHost + "/api/accounts/%s/projects/%s", accountId, projectId), new RequestData(), ProjectsResponse.class);
    }

    @Override
    public ProjectsResponse updateProject(long accountId, long projectId, CreateUpdateProjectRequest updateRequest) {
        this.validateRequestBodyAndThrowException(updateRequest);
        return this.httpClient.patch(String.format(this.apiHost + "/api/accounts/%s/projects/%s", accountId, projectId), updateRequest, new RequestData(), ProjectsResponse.class);
    }

    @Override
    public DeleteProjectResponse deleteProject(long accountId, long projectId) {
        return this.httpClient.delete(String.format(this.apiHost + "/api/accounts/%s/projects/%s", accountId, projectId), new RequestData(), DeleteProjectResponse.class);
    }
}

