/*
 * Decompiled with CFR 0.152.
 */
package io.mailtrap.client;

import io.mailtrap.client.api.MailtrapBulkSendingApi;
import io.mailtrap.client.api.MailtrapContactsApi;
import io.mailtrap.client.api.MailtrapEmailSendingApi;
import io.mailtrap.client.api.MailtrapEmailTestingApi;
import io.mailtrap.client.api.MailtrapGeneralApi;
import io.mailtrap.model.request.emails.MailtrapMail;
import io.mailtrap.model.response.emails.SendResponse;
import io.mailtrap.util.SendingContextHolder;

public class MailtrapClient {
    private final MailtrapEmailSendingApi sendingApi;
    private final MailtrapEmailTestingApi testingApi;
    private final MailtrapBulkSendingApi bulkSendingApi;
    private final MailtrapGeneralApi generalApi;
    private final MailtrapContactsApi contactsApi;
    private final SendingContextHolder sendingContextHolder;

    public SendResponse send(MailtrapMail mailtrapMail) {
        if (this.sendingContextHolder.isBulk()) {
            return this.bulkSendingApi.emails().send(mailtrapMail);
        }
        if (this.sendingContextHolder.isSandbox()) {
            return this.testingApi.emails().send(mailtrapMail, this.sendingContextHolder.getInboxId());
        }
        return this.sendingApi.emails().send(mailtrapMail);
    }

    public void switchToBulkSendingApi() {
        this.sendingContextHolder.setBulk(true);
        this.sendingContextHolder.setInboxId(null);
        this.sendingContextHolder.setSandbox(false);
    }

    public void switchToEmailTestingApi(Long inboxId) {
        this.sendingContextHolder.setInboxId(inboxId);
        this.sendingContextHolder.setSandbox(true);
        this.sendingContextHolder.setBulk(false);
    }

    public void switchToEmailSendingApi() {
        this.sendingContextHolder.setInboxId(null);
        this.sendingContextHolder.setSandbox(false);
        this.sendingContextHolder.setBulk(false);
    }

    public MailtrapClient(MailtrapEmailSendingApi sendingApi, MailtrapEmailTestingApi testingApi, MailtrapBulkSendingApi bulkSendingApi, MailtrapGeneralApi generalApi, MailtrapContactsApi contactsApi, SendingContextHolder sendingContextHolder) {
        this.sendingApi = sendingApi;
        this.testingApi = testingApi;
        this.bulkSendingApi = bulkSendingApi;
        this.generalApi = generalApi;
        this.contactsApi = contactsApi;
        this.sendingContextHolder = sendingContextHolder;
    }

    public MailtrapEmailSendingApi sendingApi() {
        return this.sendingApi;
    }

    public MailtrapEmailTestingApi testingApi() {
        return this.testingApi;
    }

    public MailtrapBulkSendingApi bulkSendingApi() {
        return this.bulkSendingApi;
    }

    public MailtrapGeneralApi generalApi() {
        return this.generalApi;
    }

    public MailtrapContactsApi contactsApi() {
        return this.contactsApi;
    }
}

