/*
 * Decompiled with CFR 0.152.
 */
package io.mailtrap.config;

import io.mailtrap.exception.BaseMailtrapException;
import io.mailtrap.http.CustomHttpClient;
import java.time.Duration;
import java.util.Objects;

public class MailtrapConfig {
    private final Duration connectionTimeout;
    private final String token;
    private final CustomHttpClient httpClient;
    private final boolean sandbox;
    private final boolean bulk;
    private final Long inboxId;

    private MailtrapConfig(Builder builder) {
        if (builder.sandbox && builder.bulk) {
            throw new BaseMailtrapException("Bulk mode is not applicable for Testing API");
        }
        if (builder.sandbox && Objects.isNull(builder.inboxId)) {
            throw new BaseMailtrapException("Testing API requires inbox ID");
        }
        this.connectionTimeout = builder.connectionTimeout;
        this.token = builder.token;
        this.httpClient = builder.httpClient;
        this.sandbox = builder.sandbox;
        this.bulk = builder.bulk;
        this.inboxId = builder.inboxId;
    }

    public Duration getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public String getToken() {
        return this.token;
    }

    public CustomHttpClient getHttpClient() {
        return this.httpClient;
    }

    public boolean isSandbox() {
        return this.sandbox;
    }

    public boolean isBulk() {
        return this.bulk;
    }

    public Long getInboxId() {
        return this.inboxId;
    }

    public static class Builder {
        private Duration connectionTimeout;
        private String token;
        private CustomHttpClient httpClient;
        private boolean sandbox;
        private boolean bulk;
        private Long inboxId;

        public Builder connectionTimeout(Duration connectionTimeout) {
            this.connectionTimeout = connectionTimeout;
            return this;
        }

        public Builder token(String token) {
            this.token = token;
            return this;
        }

        public Builder httpClient(CustomHttpClient httpClient) {
            this.httpClient = httpClient;
            return this;
        }

        public Builder sandbox(boolean sandbox) {
            this.sandbox = sandbox;
            return this;
        }

        public Builder bulk(boolean bulk) {
            this.bulk = bulk;
            return this;
        }

        public Builder inboxId(Long inboxId) {
            this.inboxId = inboxId;
            return this;
        }

        public MailtrapConfig build() {
            return new MailtrapConfig(this);
        }
    }
}

