/*
 * Decompiled with CFR 0.152.
 */
package io.mailtrap.factory;

import io.mailtrap.CustomValidator;
import io.mailtrap.api.accountaccesses.AccountAccessesImpl;
import io.mailtrap.api.accounts.AccountsImpl;
import io.mailtrap.api.attachments.AttachmentsImpl;
import io.mailtrap.api.billing.BillingImpl;
import io.mailtrap.api.bulkemails.BulkEmailsImpl;
import io.mailtrap.api.contactlists.ContactListsImpl;
import io.mailtrap.api.contacts.ContactsImpl;
import io.mailtrap.api.inboxes.InboxesImpl;
import io.mailtrap.api.messages.MessagesImpl;
import io.mailtrap.api.permissions.PermissionsImpl;
import io.mailtrap.api.projects.ProjectsImpl;
import io.mailtrap.api.sendingdomains.SendingDomainsImpl;
import io.mailtrap.api.sendingemails.SendingEmailsImpl;
import io.mailtrap.api.testingemails.TestingEmailsImpl;
import io.mailtrap.client.MailtrapClient;
import io.mailtrap.client.api.MailtrapBulkSendingApi;
import io.mailtrap.client.api.MailtrapContactsApi;
import io.mailtrap.client.api.MailtrapEmailSendingApi;
import io.mailtrap.client.api.MailtrapEmailTestingApi;
import io.mailtrap.client.api.MailtrapGeneralApi;
import io.mailtrap.config.MailtrapConfig;
import io.mailtrap.util.SendingContextHolder;
import jakarta.validation.Validation;
import jakarta.validation.ValidatorFactory;

public final class MailtrapClientFactory {
    private MailtrapClientFactory() {
    }

    public static MailtrapClient createMailtrapClient(MailtrapConfig config) {
        CustomValidator customValidator = MailtrapClientFactory.createValidator();
        MailtrapEmailSendingApi sendingApi = MailtrapClientFactory.createSendingApi(config, customValidator);
        MailtrapEmailTestingApi testingApi = MailtrapClientFactory.createTestingApi(config, customValidator);
        MailtrapBulkSendingApi bulkSendingApi = MailtrapClientFactory.createBulkSendingApi(config, customValidator);
        MailtrapGeneralApi generalApi = MailtrapClientFactory.createGeneralApi(config);
        MailtrapContactsApi contactsApi = MailtrapClientFactory.createContactsApi(config);
        SendingContextHolder sendingContextHolder = MailtrapClientFactory.configureSendingContext(config);
        return new MailtrapClient(sendingApi, testingApi, bulkSendingApi, generalApi, contactsApi, sendingContextHolder);
    }

    private static MailtrapContactsApi createContactsApi(MailtrapConfig config) {
        ContactListsImpl contactLists = new ContactListsImpl(config);
        ContactsImpl contacts = new ContactsImpl(config);
        return new MailtrapContactsApi(contactLists, contacts);
    }

    private static MailtrapGeneralApi createGeneralApi(MailtrapConfig config) {
        AccountAccessesImpl accountAccess = new AccountAccessesImpl(config);
        AccountsImpl accounts = new AccountsImpl(config);
        BillingImpl billing = new BillingImpl(config);
        PermissionsImpl permissions = new PermissionsImpl(config);
        return new MailtrapGeneralApi(accountAccess, accounts, billing, permissions);
    }

    private static MailtrapEmailSendingApi createSendingApi(MailtrapConfig config, CustomValidator customValidator) {
        SendingEmailsImpl emails = new SendingEmailsImpl(config, customValidator);
        SendingDomainsImpl domains = new SendingDomainsImpl(config);
        return new MailtrapEmailSendingApi(emails, domains);
    }

    private static MailtrapEmailTestingApi createTestingApi(MailtrapConfig config, CustomValidator customValidator) {
        TestingEmailsImpl emails = new TestingEmailsImpl(config, customValidator);
        AttachmentsImpl attachments = new AttachmentsImpl(config);
        InboxesImpl inboxes = new InboxesImpl(config, customValidator);
        ProjectsImpl projects = new ProjectsImpl(config, customValidator);
        MessagesImpl messages = new MessagesImpl(config);
        return new MailtrapEmailTestingApi(emails, attachments, inboxes, projects, messages);
    }

    private static MailtrapBulkSendingApi createBulkSendingApi(MailtrapConfig config, CustomValidator customValidator) {
        BulkEmailsImpl emails = new BulkEmailsImpl(config, customValidator);
        return new MailtrapBulkSendingApi(emails);
    }

    private static SendingContextHolder configureSendingContext(MailtrapConfig config) {
        return SendingContextHolder.builder().sandbox(config.isSandbox()).inboxId(config.getInboxId()).bulk(config.isBulk()).build();
    }

    private static CustomValidator createValidator() {
        try (ValidatorFactory factory = Validation.buildDefaultValidatorFactory();){
            CustomValidator customValidator = new CustomValidator(factory.getValidator());
            return customValidator;
        }
    }
}

