/*
 * Decompiled with CFR 0.152.
 */
package io.mailtrap.http;

import io.mailtrap.exception.http.HttpException;
import io.mailtrap.http.RequestData;
import io.mailtrap.model.AbstractModel;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public interface CustomHttpClient {
    public <T> T get(String var1, RequestData var2, Class<T> var3) throws HttpException;

    public <T> List<T> getList(String var1, RequestData var2, Class<T> var3) throws HttpException;

    public <T> T delete(String var1, RequestData var2, Class<T> var3) throws HttpException;

    public <T> T head(String var1, RequestData var2, Class<T> var3) throws HttpException;

    public <T, V extends AbstractModel> T post(String var1, V var2, RequestData var3, Class<T> var4) throws HttpException;

    public <T, V extends AbstractModel> T put(String var1, V var2, RequestData var3, Class<T> var4) throws HttpException;

    public <T, V extends AbstractModel> T patch(String var1, V var2, RequestData var3, Class<T> var4) throws HttpException;

    default public String appendUrlParams(String url, Map<String, ? extends Optional<?>> urlParams) {
        if (urlParams.isEmpty() || urlParams.entrySet().stream().noneMatch(e -> ((Optional)e.getValue()).isPresent())) {
            return url;
        }
        return url + urlParams.entrySet().stream().filter(entry -> ((Optional)entry.getValue()).isPresent()).flatMap(entry -> {
            Object value = ((Optional)entry.getValue()).get();
            if (value instanceof Collection) {
                Collection collection = (Collection)value;
                return collection.stream().filter(Objects::nonNull).filter(v -> !v.toString().isBlank()).map(v -> (String)entry.getKey() + "=" + String.valueOf(v));
            }
            return Stream.of((String)entry.getKey() + "=" + String.valueOf(value));
        }).collect(Collectors.joining("&", "?", ""));
    }
}

