/*
 * Decompiled with CFR 0.152.
 */
package io.mailtrap.model.request.emails;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.mailtrap.model.AbstractModel;
import jakarta.validation.constraints.NotEmpty;

public class EmailAttachment
extends AbstractModel {
    @NotEmpty
    private String content;
    private String type;
    @NotEmpty
    private String filename;
    private String disposition;
    @JsonProperty(value="content_id")
    private String contentId;

    EmailAttachment(String content, String type, String filename, String disposition, String contentId) {
        this.content = content;
        this.type = type;
        this.filename = filename;
        this.disposition = disposition;
        this.contentId = contentId;
    }

    public static EmailAttachmentBuilder builder() {
        return new EmailAttachmentBuilder();
    }

    public String getContent() {
        return this.content;
    }

    public String getType() {
        return this.type;
    }

    public String getFilename() {
        return this.filename;
    }

    public String getDisposition() {
        return this.disposition;
    }

    public String getContentId() {
        return this.contentId;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public void setDisposition(String disposition) {
        this.disposition = disposition;
    }

    @JsonProperty(value="content_id")
    public void setContentId(String contentId) {
        this.contentId = contentId;
    }

    public static class EmailAttachmentBuilder {
        private String content;
        private String type;
        private String filename;
        private String disposition;
        private String contentId;

        EmailAttachmentBuilder() {
        }

        public EmailAttachmentBuilder content(String content) {
            this.content = content;
            return this;
        }

        public EmailAttachmentBuilder type(String type) {
            this.type = type;
            return this;
        }

        public EmailAttachmentBuilder filename(String filename) {
            this.filename = filename;
            return this;
        }

        public EmailAttachmentBuilder disposition(String disposition) {
            this.disposition = disposition;
            return this;
        }

        @JsonProperty(value="content_id")
        public EmailAttachmentBuilder contentId(String contentId) {
            this.contentId = contentId;
            return this;
        }

        public EmailAttachment build() {
            return new EmailAttachment(this.content, this.type, this.filename, this.disposition, this.contentId);
        }

        public String toString() {
            return "EmailAttachment.EmailAttachmentBuilder(content=" + this.content + ", type=" + this.type + ", filename=" + this.filename + ", disposition=" + this.disposition + ", contentId=" + this.contentId + ")";
        }
    }
}

