/*
 * Decompiled with CFR 0.152.
 */
package io.mailtrap.serialization;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.mailtrap.model.response.Permission;
import io.mailtrap.model.response.accountaccesses.AccountAccessResponse;
import io.mailtrap.model.response.accountaccesses.ApiTokenSpecifier;
import io.mailtrap.model.response.accountaccesses.InviteSpecifier;
import io.mailtrap.model.response.accountaccesses.Resource;
import io.mailtrap.model.response.accountaccesses.Specifier;
import io.mailtrap.model.response.accountaccesses.SpecifierType;
import io.mailtrap.model.response.accountaccesses.UserSpecifier;
import java.io.IOException;
import java.util.List;

public class AccountAccessResponseDeserializer
extends JsonDeserializer<AccountAccessResponse> {
    public AccountAccessResponse deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        ObjectMapper mapper = (ObjectMapper)p.getCodec();
        JsonNode rootNode = (JsonNode)mapper.readTree(p);
        long id = rootNode.get("id").asLong();
        JsonNode resourcesNode = rootNode.get("resources");
        JsonNode permissionsNode = rootNode.get("permissions");
        List resources = (List)mapper.convertValue((Object)resourcesNode, (TypeReference)new TypeReference<List<Resource>>(){});
        Permission permissions = (Permission)mapper.treeToValue((TreeNode)permissionsNode, Permission.class);
        String specifierTypeStr = rootNode.get("specifier_type").asText();
        SpecifierType specifierType = SpecifierType.fromValue(specifierTypeStr);
        JsonNode specifierNode = rootNode.get("specifier");
        Specifier specifier = switch (specifierType) {
            default -> throw new IncompatibleClassChangeError();
            case SpecifierType.USER -> (UserSpecifier)mapper.treeToValue((TreeNode)specifierNode, UserSpecifier.class);
            case SpecifierType.INVITE -> (InviteSpecifier)mapper.treeToValue((TreeNode)specifierNode, InviteSpecifier.class);
            case SpecifierType.API_TOKEN -> (ApiTokenSpecifier)mapper.treeToValue((TreeNode)specifierNode, ApiTokenSpecifier.class);
        };
        AccountAccessResponse response = new AccountAccessResponse();
        response.setId(id);
        response.setSpecifier(specifier);
        response.setSpecifierType(specifierType);
        response.setResources(resources);
        response.setPermission(permissions);
        return response;
    }
}

