/*
 * Decompiled with CFR 0.152.
 */
package io.mailtrap.serialization;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import io.mailtrap.model.response.ErrorResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;

public class ErrorResponseDeserializer
extends JsonDeserializer<ErrorResponse> {
    public ErrorResponse deserialize(JsonParser p, DeserializationContext deserializationContext) throws IOException {
        JsonNode node = (JsonNode)p.getCodec().readTree(p);
        ArrayList<String> errors = new ArrayList<String>();
        if (node.has("errors")) {
            JsonNode errorsNode = node.get("errors");
            if (errorsNode.isArray()) {
                Iterator elements = errorsNode.elements();
                while (elements.hasNext()) {
                    errors.add(((JsonNode)elements.next()).asText());
                }
            } else if (errorsNode.isTextual()) {
                errors.add(errorsNode.asText());
            } else if (errorsNode.isObject()) {
                Iterator fields = errorsNode.fields();
                while (fields.hasNext()) {
                    Map.Entry field = (Map.Entry)fields.next();
                    JsonNode fieldValue = (JsonNode)field.getValue();
                    if (fieldValue.isArray()) {
                        Iterator fieldElements = fieldValue.elements();
                        while (fieldElements.hasNext()) {
                            errors.add(((JsonNode)fieldElements.next()).asText());
                        }
                        continue;
                    }
                    if (!fieldValue.isTextual()) continue;
                    errors.add(fieldValue.asText());
                }
            }
        } else if (node.has("error") && node.get("error").isTextual()) {
            errors.add(node.get("error").asText());
        }
        return new ErrorResponse(errors);
    }
}

