/*
 * Decompiled with CFR 0.152.
 */
package com.cybozu.labs.langdetect;

import com.cybozu.labs.langdetect.Detector;
import com.cybozu.labs.langdetect.DetectorFactory;
import com.cybozu.labs.langdetect.GenProfile;
import com.cybozu.labs.langdetect.LangDetectException;
import com.cybozu.labs.langdetect.util.LangProfile;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.arnx.jsonic.JSON;
import net.arnx.jsonic.JSONException;

public class Command
implements Serializable {
    private static final double DEFAULT_ALPHA = 0.5;
    private Map<String, String> opt_with_value = new HashMap<String, String>();
    private Map<String, String> values = new HashMap<String, String>();
    private Set<String> opt_without_value = new HashSet<String>();
    private List<String> arglist = new ArrayList<String>();
    private DetectorFactory detectFact = new DetectorFactory();

    private void parse(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (this.opt_with_value.containsKey(stringArray[i])) {
                String string = this.opt_with_value.get(stringArray[i]);
                this.values.put(string, stringArray[i + 1]);
                ++i;
                continue;
            }
            if (stringArray[i].startsWith("-")) {
                this.opt_without_value.add(stringArray[i]);
                continue;
            }
            this.arglist.add(stringArray[i]);
        }
    }

    private void addOpt(String string, String string2, String string3) {
        this.opt_with_value.put(string, string2);
        this.values.put(string2, string3);
    }

    private String get(String string) {
        return this.values.get(string);
    }

    private Long getLong(String string) {
        String string2 = this.values.get(string);
        if (string2 == null) {
            return null;
        }
        try {
            return Long.valueOf(string2);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    private double getDouble(String string, double d) {
        try {
            return Double.valueOf(this.values.get(string));
        }
        catch (NumberFormatException numberFormatException) {
            return d;
        }
    }

    private boolean hasOpt(String string) {
        return this.opt_without_value.contains(string);
    }

    private File searchFile(File file, String string) {
        File[] fileArray = file.listFiles();
        if (fileArray != null) {
            for (File file2 : fileArray) {
                if (!file2.getName().matches(string)) continue;
                return file2;
            }
        }
        return null;
    }

    private boolean loadProfile() {
        String string = this.get("directory") + "/";
        try {
            this.detectFact.loadProfile(string);
            Long l = this.getLong("seed");
            if (l != null) {
                this.detectFact.setSeed(l);
            }
            return false;
        }
        catch (LangDetectException langDetectException) {
            System.err.println("ERROR: " + langDetectException.getMessage());
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generateProfile() {
        File file = new File(this.get("directory"));
        for (String string : this.arglist) {
            File file2 = this.searchFile(file, string + "wiki-.*-abstract\\.xml.*");
            if (file2 == null) {
                System.err.println("Not Found abstract xml : lang = " + string);
                continue;
            }
            FileOutputStream fileOutputStream = null;
            try {
                LangProfile langProfile = GenProfile.loadFromWikipediaAbstract(string, file2);
                langProfile.omitLessFreq();
                File file3 = new File(this.get("directory") + "/profiles/" + string);
                fileOutputStream = new FileOutputStream(file3);
                JSON.encode((Object)langProfile, (OutputStream)fileOutputStream);
            }
            catch (JSONException jSONException) {
                jSONException.printStackTrace();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            catch (LangDetectException langDetectException) {
                langDetectException.printStackTrace();
            }
            finally {
                try {
                    if (fileOutputStream == null) continue;
                    fileOutputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateProfileFromText() {
        if (this.arglist.size() != 1) {
            System.err.println("Need to specify text file path");
            return;
        }
        File file = new File(this.arglist.get(0));
        if (!file.exists()) {
            System.err.println("Need to specify existing text file path");
            return;
        }
        String string = this.get("lang");
        if (string == null) {
            System.err.println("Need to specify langage code(-l)");
            return;
        }
        FileOutputStream fileOutputStream = null;
        try {
            LangProfile langProfile = GenProfile.loadFromText(string, file);
            langProfile.omitLessFreq();
            File file2 = new File(string);
            fileOutputStream = new FileOutputStream(file2);
            JSON.encode((Object)langProfile, (OutputStream)fileOutputStream);
        }
        catch (LangDetectException | IOException | JSONException throwable) {
            throwable.printStackTrace();
        }
        finally {
            try {
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void detectLang() {
        if (this.loadProfile()) {
            return;
        }
        for (String string : this.arglist) {
            BufferedReader bufferedReader = null;
            try {
                bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(string), "utf-8"));
                Detector detector = this.detectFact.create(this.getDouble("alpha", 0.5));
                if (this.hasOpt("--debug")) {
                    detector.setVerbose();
                }
                detector.append(bufferedReader);
                System.out.println(string + ":" + detector.getProbabilities());
            }
            catch (LangDetectException | IOException exception) {
                exception.printStackTrace();
            }
            finally {
                try {
                    if (bufferedReader == null) continue;
                    bufferedReader.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void batchTest() {
        if (this.loadProfile()) {
            return;
        }
        HashMap hashMap = new HashMap();
        for (String string : this.arglist) {
            Object object;
            Object object2;
            Object object3;
            int n;
            Object object4;
            BufferedReader bufferedReader = null;
            try {
                bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(string), "utf-8"));
                while (bufferedReader.ready()) {
                    object4 = bufferedReader.readLine();
                    n = ((String)object4).indexOf(9);
                    if (n <= 0) continue;
                    String string2 = ((String)object4).substring(0, n);
                    object3 = ((String)object4).substring(n + 1);
                    object2 = this.detectFact.create(this.getDouble("alpha", 0.5));
                    ((Detector)object2).append((String)object3);
                    object = "";
                    try {
                        object = ((Detector)object2).detect();
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    if (!hashMap.containsKey(string2)) {
                        hashMap.put(string2, new ArrayList());
                    }
                    ((ArrayList)hashMap.get(string2)).add(object);
                    if (!this.hasOpt("--debug")) continue;
                    System.out.println(string2 + "," + (String)object + "," + (String)(((String)object3).length() > 100 ? ((String)object3).substring(0, 100) : object3));
                }
            }
            catch (LangDetectException | IOException exception) {
                exception.printStackTrace();
            }
            finally {
                try {
                    if (bufferedReader != null) {
                        bufferedReader.close();
                    }
                }
                catch (IOException iOException) {}
            }
            object4 = new ArrayList(hashMap.keySet());
            Collections.sort(object4);
            n = 0;
            int n2 = 0;
            object3 = ((ArrayList)object4).iterator();
            while (object3.hasNext()) {
                object2 = (String)object3.next();
                object = new HashMap();
                int n3 = 0;
                ArrayList arrayList = (ArrayList)hashMap.get(object2);
                for (String string3 : arrayList) {
                    ++n3;
                    if (((HashMap)object).containsKey(string3)) {
                        ((HashMap)object).put(string3, (Integer)((HashMap)object).get(string3) + 1);
                        continue;
                    }
                    ((HashMap)object).put(string3, 1);
                }
                int n4 = ((HashMap)object).containsKey(object2) ? (Integer)((HashMap)object).get(object2) : 0;
                double d = (double)n4 / (double)n3;
                System.out.println(String.format("%s (%d/%d=%.2f): %s", object2, n4, n3, d, object));
                n2 += n4;
                n += n3;
            }
            System.out.println(String.format("total: %d/%d = %.3f", n2, n, (double)n2 / (double)n));
        }
    }

    public static void main(String[] stringArray) {
        Command command = new Command();
        command.addOpt("-d", "directory", "./");
        command.addOpt("-a", "alpha", "0.5");
        command.addOpt("-s", "seed", null);
        command.addOpt("-l", "lang", null);
        command.parse(stringArray);
        if (command.hasOpt("--genprofile")) {
            command.generateProfile();
        } else if (command.hasOpt("--genprofile-text")) {
            command.generateProfileFromText();
        } else if (command.hasOpt("--detectlang")) {
            command.detectLang();
        } else if (command.hasOpt("--batchtest")) {
            command.batchTest();
        }
    }
}

