/*
 * Decompiled with CFR 0.152.
 */
package com.cybozu.labs.langdetect;

import com.cybozu.labs.langdetect.Detector;
import com.cybozu.labs.langdetect.ErrorCode;
import com.cybozu.labs.langdetect.LangDetectException;
import com.cybozu.labs.langdetect.util.LangProfile;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.arnx.jsonic.JSON;
import net.arnx.jsonic.JSONException;

public class DetectorFactory
implements Serializable {
    private Map<String, double[]> wordLangProbMap;
    private List<String> langlist;
    private long seed;

    public DetectorFactory() {
        this(new HashMap<String, double[]>(), new ArrayList<String>(), Double.doubleToLongBits(Math.random() * 10000.0));
    }

    public DetectorFactory(Map<String, double[]> map, ArrayList<String> arrayList, long l) {
        this.wordLangProbMap = map;
        this.langlist = arrayList;
        this.seed = l;
    }

    public long getSeed() {
        return this.seed;
    }

    public void setSeed(long l) {
        this.seed = l;
    }

    public List<String> getLangList() {
        return Collections.unmodifiableList(this.langlist);
    }

    public Map<String, double[]> getWordLangProbMap() {
        return Collections.unmodifiableMap(this.wordLangProbMap);
    }

    public void loadProfile(String string) throws LangDetectException {
        this.loadProfile(new File(string));
    }

    public void loadProfile(File file) throws LangDetectException {
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            throw new LangDetectException(ErrorCode.NeedLoadProfileError, "Not found profile: " + file);
        }
        int n = fileArray.length;
        int n2 = 0;
        for (File file2 : fileArray) {
            if (file2.getName().startsWith(".") || !file2.isFile()) continue;
            FileInputStream fileInputStream = null;
            try {
                fileInputStream = new FileInputStream(file2);
                LangProfile langProfile = (LangProfile)JSON.decode((InputStream)fileInputStream, LangProfile.class);
                this.addProfile(langProfile, n2, n);
                ++n2;
            }
            catch (JSONException jSONException) {
                throw new LangDetectException(ErrorCode.FormatError, "profile format error in '" + file2.getName() + "'");
            }
            catch (IOException iOException) {
                throw new LangDetectException(ErrorCode.FileLoadError, "can't open '" + file2.getName() + "'");
            }
            finally {
                try {
                    if (fileInputStream != null) {
                        fileInputStream.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
    }

    public void loadProfile(List<String> list) throws LangDetectException {
        int n = list.size();
        if (n < 2) {
            throw new LangDetectException(ErrorCode.NeedLoadProfileError, "Need more than 2 profiles");
        }
        int n2 = 0;
        for (String string : list) {
            try {
                LangProfile langProfile = (LangProfile)JSON.decode((String)string, LangProfile.class);
                this.addProfile(langProfile, n2, n);
                ++n2;
            }
            catch (JSONException jSONException) {
                throw new LangDetectException(ErrorCode.FormatError, "profile format error");
            }
        }
    }

    public void addProfile(LangProfile langProfile, int n, int n2) throws LangDetectException {
        String string = langProfile.name;
        if (this.langlist.contains(string)) {
            throw new LangDetectException(ErrorCode.DuplicateLangError, "duplicate the same language profile");
        }
        this.langlist.add(string);
        for (String string2 : langProfile.freq.keySet()) {
            double d;
            int n3;
            if (!this.wordLangProbMap.containsKey(string2)) {
                this.wordLangProbMap.put(string2, new double[n2]);
            }
            if ((n3 = string2.length()) < 1 || n3 > 3) continue;
            this.wordLangProbMap.get((Object)string2)[n] = d = langProfile.freq.get(string2).doubleValue() / (double)langProfile.n_words[n3 - 1];
        }
    }

    public void clear() {
        this.langlist.clear();
        this.wordLangProbMap.clear();
    }

    public Detector create() throws LangDetectException {
        return this.createDetector();
    }

    public Detector create(double d) throws LangDetectException {
        Detector detector = this.createDetector();
        detector.setAlpha(d);
        return detector;
    }

    private Detector createDetector() throws LangDetectException {
        if (this.langlist.isEmpty()) {
            throw new LangDetectException(ErrorCode.NeedLoadProfileError, "need to load profiles");
        }
        return new Detector(this);
    }
}

