/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.common;

import io.mantisrx.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import io.mantisrx.shaded.com.fasterxml.jackson.annotation.JsonIgnore;
import io.mantisrx.shaded.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.mantisrx.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class WorkerPorts {
    private final int metricsPort;
    private final int debugPort;
    private final int consolePort;
    private final int customPort;
    private int sinkPort;
    private List<Integer> ports;

    public WorkerPorts(List<Integer> assignedPorts) {
        if (assignedPorts.size() < 5) {
            throw new IllegalArgumentException("assignedPorts should have at least 5 ports");
        }
        this.metricsPort = assignedPorts.get(0);
        this.debugPort = assignedPorts.get(1);
        this.consolePort = assignedPorts.get(2);
        this.customPort = assignedPorts.get(3);
        this.ports = new ArrayList<Integer>(3);
        int idx = 4;
        if (idx < assignedPorts.size()) {
            this.ports.add(assignedPorts.get(idx));
            this.sinkPort = assignedPorts.get(idx);
        }
        if (!this.isValid()) {
            throw new IllegalStateException("worker validation failed on port allocation");
        }
    }

    public WorkerPorts(int metricsPort, int debugPort, int consolePort, int customPort, int sinkPort) {
        this.ports = new ArrayList<Integer>(5);
        this.sinkPort = sinkPort;
        this.ports.add(sinkPort);
        this.metricsPort = metricsPort;
        this.ports.add(metricsPort);
        this.debugPort = debugPort;
        this.ports.add(debugPort);
        this.consolePort = consolePort;
        this.ports.add(consolePort);
        this.customPort = customPort;
        this.ports.add(customPort);
    }

    @JsonCreator
    @JsonIgnoreProperties(ignoreUnknown=true)
    public WorkerPorts(@JsonProperty(value="metricsPort") int metricsPort, @JsonProperty(value="debugPort") int debugPort, @JsonProperty(value="consolePort") int consolePort, @JsonProperty(value="customPort") int customPort, @JsonProperty(value="ports") List<Integer> ports) {
        this.metricsPort = metricsPort;
        this.debugPort = debugPort;
        this.consolePort = consolePort;
        this.customPort = customPort;
        this.ports = ports;
    }

    public int getMetricsPort() {
        return this.metricsPort;
    }

    public int getDebugPort() {
        return this.debugPort;
    }

    public int getConsolePort() {
        return this.consolePort;
    }

    public int getCustomPort() {
        return this.customPort;
    }

    public int getSinkPort() {
        return this.sinkPort;
    }

    @JsonIgnore
    public List<Integer> getAllPorts() {
        ArrayList<Integer> allPorts = new ArrayList<Integer>(this.ports);
        allPorts.add(this.metricsPort);
        allPorts.add(this.debugPort);
        allPorts.add(this.consolePort);
        allPorts.add(this.customPort);
        return allPorts;
    }

    public List<Integer> getPorts() {
        return this.ports;
    }

    public boolean isValid() {
        HashSet<Integer> uniquePorts = new HashSet<Integer>();
        uniquePorts.add(this.metricsPort);
        uniquePorts.add(this.consolePort);
        uniquePorts.add(this.debugPort);
        uniquePorts.add(this.customPort);
        uniquePorts.add(this.sinkPort);
        return uniquePorts.size() >= 5 && this.isValidPort(this.metricsPort) && this.isValidPort(this.consolePort) && this.isValidPort(this.debugPort) && this.isValidPort(this.customPort) && this.isValidPort(this.sinkPort);
    }

    private boolean isValidPort(int port) {
        return port > 0 && port <= 65535;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WorkerPorts that = (WorkerPorts)o;
        if (this.metricsPort != that.metricsPort) {
            return false;
        }
        if (this.debugPort != that.debugPort) {
            return false;
        }
        if (this.consolePort != that.consolePort) {
            return false;
        }
        return this.ports != null ? this.ports.equals(that.ports) : that.ports == null;
    }

    public int hashCode() {
        int result = this.metricsPort;
        result = 31 * result + this.debugPort;
        result = 31 * result + this.consolePort;
        result = 31 * result + (this.ports != null ? this.ports.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "WorkerPorts{ metricsPort=" + this.metricsPort + ", debugPort=" + this.debugPort + ", consolePort=" + this.consolePort + ", customPort=" + this.customPort + ", sinkPort=" + this.sinkPort + ", ports=" + this.ports + '}';
    }
}

