/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.common.codec;

import io.mantisrx.common.codec.Codec;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;

public class Codecs {
    public static Codec<Integer> integer() {
        return new Codec<Integer>(){

            @Override
            public Integer decode(byte[] bytes) {
                return ByteBuffer.wrap(bytes).getInt();
            }

            @Override
            public byte[] encode(Integer value) {
                return ByteBuffer.allocate(4).putInt(value).array();
            }
        };
    }

    public static Codec<Long> longNumber() {
        return new Codec<Long>(){

            @Override
            public Long decode(byte[] bytes) {
                return ByteBuffer.wrap(bytes).getLong();
            }

            @Override
            public byte[] encode(Long value) {
                return ByteBuffer.allocate(8).putLong(value).array();
            }
        };
    }

    private static Codec<String> stringWithEncoding(String encoding) {
        final Charset charset = Charset.forName(encoding);
        return new Codec<String>(){

            @Override
            public String decode(byte[] bytes) {
                return new String(bytes, charset);
            }

            @Override
            public byte[] encode(String value) {
                return value.getBytes(charset);
            }
        };
    }

    public static Codec<String> stringAscii() {
        final Charset charset = Charset.forName("US-ASCII");
        return new Codec<String>(){

            @Override
            public String decode(byte[] bytes) {
                return new String(bytes, charset);
            }

            @Override
            public byte[] encode(String value) {
                byte[] bytes = new byte[value.length()];
                for (int i = 0; i < value.length(); ++i) {
                    bytes[i] = (byte)value.charAt(i);
                }
                return bytes;
            }
        };
    }

    public static Codec<String> stringUtf8() {
        return Codecs.stringWithEncoding("UTF-8");
    }

    public static Codec<String> string() {
        return Codecs.stringUtf8();
    }

    public static Codec<byte[]> bytearray() {
        return new Codec<byte[]>(){

            @Override
            public byte[] decode(byte[] bytes) {
                return bytes;
            }

            @Override
            public byte[] encode(byte[] value) {
                return value;
            }
        };
    }
}

