/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.runtime;

import io.mantisrx.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import io.mantisrx.shaded.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.mantisrx.shaded.com.fasterxml.jackson.annotation.JsonProperty;

public class MachineDefinition {
    private static final double defaultMbps = 128.0;
    private static final int minPorts = 1;
    private final double cpuCores;
    private final double memoryMB;
    private final double networkMbps;
    private final double diskMB;
    private final int numPorts;

    @JsonCreator
    @JsonIgnoreProperties(ignoreUnknown=true)
    public MachineDefinition(@JsonProperty(value="cpuCores") double cpuCores, @JsonProperty(value="memoryMB") double memoryMB, @JsonProperty(value="networkMbps") double networkMbps, @JsonProperty(value="diskMB") double diskMB, @JsonProperty(value="numPorts") int numPorts) {
        this.cpuCores = cpuCores;
        this.memoryMB = memoryMB;
        this.networkMbps = networkMbps == 0.0 ? 128.0 : networkMbps;
        this.diskMB = diskMB;
        this.numPorts = Math.max(1, numPorts);
    }

    public MachineDefinition(double cpuCores, double memoryMB, double diskMB, int numPorts) {
        this.cpuCores = cpuCores;
        this.memoryMB = memoryMB;
        this.diskMB = diskMB;
        this.numPorts = Math.max(1, numPorts);
        this.networkMbps = 128.0;
    }

    public double getCpuCores() {
        return this.cpuCores;
    }

    public double getMemoryMB() {
        return this.memoryMB;
    }

    public double getNetworkMbps() {
        return this.networkMbps;
    }

    public double getDiskMB() {
        return this.diskMB;
    }

    public int getNumPorts() {
        return this.numPorts;
    }

    public String toString() {
        return "MachineDefinition{cpuCores=" + this.cpuCores + ", memoryMB=" + this.memoryMB + ", networkMbps=" + this.networkMbps + ", diskMB=" + this.diskMB + ", numPorts=" + this.numPorts + '}';
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        long temp = Double.doubleToLongBits(this.cpuCores);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.diskMB);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.memoryMB);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.networkMbps);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + this.numPorts;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MachineDefinition other = (MachineDefinition)obj;
        if (Double.doubleToLongBits(this.cpuCores) != Double.doubleToLongBits(other.cpuCores)) {
            return false;
        }
        if (Double.doubleToLongBits(this.diskMB) != Double.doubleToLongBits(other.diskMB)) {
            return false;
        }
        if (Double.doubleToLongBits(this.memoryMB) != Double.doubleToLongBits(other.memoryMB)) {
            return false;
        }
        if (Double.doubleToLongBits(this.networkMbps) != Double.doubleToLongBits(other.networkMbps)) {
            return false;
        }
        return this.numPorts == other.numPorts;
    }
}

