/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.config.dynamic;

import io.mantisrx.common.properties.MantisPropertiesLoader;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DynamicProperty<T> {
    private static final Logger log = LoggerFactory.getLogger(DynamicProperty.class);
    public static final String DYNAMIC_PROPERTY_REFRESH_SECONDS_KEY = "mantis.config.dynamic.refreshSecs";
    protected final MantisPropertiesLoader propertiesLoader;
    protected final String propertyName;
    protected final T defaultValue;
    protected T lastValue;
    protected Instant lastRefreshTime;
    private final Duration refreshDuration;
    private final Clock clock;

    public DynamicProperty(MantisPropertiesLoader propertiesLoader, String propertyName, T defaultValue, Clock clock) {
        this.propertiesLoader = propertiesLoader;
        this.propertyName = propertyName;
        this.defaultValue = defaultValue;
        this.lastValue = defaultValue;
        this.clock = clock;
        this.lastRefreshTime = Instant.MIN;
        try {
            this.refreshDuration = Duration.ofSeconds(Long.parseLong(propertiesLoader.getStringValue(DYNAMIC_PROPERTY_REFRESH_SECONDS_KEY, "30")));
        }
        catch (NumberFormatException ex) {
            throw new RuntimeException("invalid refresh secs for dynamic property: " + propertyName);
        }
    }

    public DynamicProperty(MantisPropertiesLoader propertiesLoader, String propertyName, T defaultValue) {
        this(propertiesLoader, propertyName, defaultValue, Clock.systemDefaultZone());
    }

    protected String getStringValue() {
        this.lastRefreshTime = this.clock.instant();
        return this.propertiesLoader.getStringValue(this.propertyName, this.lastValue.toString());
    }

    private boolean shouldRefresh() {
        return this.clock.instant().isAfter(this.lastRefreshTime.plus(this.refreshDuration));
    }

    protected abstract T convertFromString(String var1);

    public T getValue() {
        if (this.shouldRefresh()) {
            String newStrVal = this.getStringValue();
            T newVal = this.convertFromString(newStrVal);
            if (!Objects.equals(this.lastValue, newVal)) {
                log.info("[DP: {}] value changed from {} to {}", new Object[]{this.propertyName, this.lastValue, newVal});
            }
            this.lastValue = newVal;
        }
        return this.lastValue;
    }
}

