/*
 * Decompiled with CFR 0.152.
 */
package io.reactivx.mantis.operators;

import rx.Observable;
import rx.Producer;
import rx.Subscriber;
import rx.Subscription;
import rx.exceptions.Exceptions;
import rx.functions.Func1;
import rx.plugins.RxJavaPlugins;

public final class OperatorOnErrorResumeNextViaFunction<T>
implements Observable.Operator<T, T> {
    private final Func1<Throwable, ? extends Observable<? extends T>> resumeFunction;

    public OperatorOnErrorResumeNextViaFunction(Func1<Throwable, ? extends Observable<? extends T>> f) {
        this.resumeFunction = f;
    }

    public Subscriber<? super T> call(final Subscriber<? super T> child) {
        Subscriber parent = new Subscriber<T>(){
            private boolean done = false;

            public void onCompleted() {
                if (this.done) {
                    return;
                }
                this.done = true;
                child.onCompleted();
            }

            public void onError(Throwable e) {
                if (this.done) {
                    Exceptions.throwIfFatal((Throwable)e);
                    return;
                }
                this.done = true;
                try {
                    RxJavaPlugins.getInstance().getErrorHandler().handleError(e);
                    this.unsubscribe();
                    Observable resume = (Observable)OperatorOnErrorResumeNextViaFunction.this.resumeFunction.call((Object)e);
                    resume.unsafeSubscribe(child);
                }
                catch (Throwable e2) {
                    child.onError(e2);
                }
            }

            public void onNext(T t) {
                if (this.done) {
                    return;
                }
                child.onNext(t);
            }

            public void setProducer(final Producer producer) {
                child.setProducer(new Producer(){

                    public void request(long n) {
                        producer.request(n);
                    }
                });
            }
        };
        child.add((Subscription)parent);
        return parent;
    }
}

