/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.server.master.client.config;

import io.mantisrx.shaded.org.apache.curator.shaded.com.google.common.base.Preconditions;
import java.beans.ConstructorProperties;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Properties;
import org.apache.flink.util.ExceptionUtils;
import org.skife.config.Coercer;
import org.skife.config.Coercible;

public class PluginCoercible<T>
implements Coercible<T> {
    private final Class<T> tClass;
    private final Properties properties;

    public Coercer<T> accept(Class<?> type) {
        if (this.tClass.isAssignableFrom(type)) {
            return value -> {
                try {
                    Class<?> derivedType = Class.forName(value);
                    Method candidate = derivedType.getMethod("valueOf", Properties.class);
                    Preconditions.checkArgument((boolean)Modifier.isStatic(candidate.getModifiers()));
                    Preconditions.checkArgument((boolean)type.isAssignableFrom(candidate.getReturnType()));
                    return candidate.invoke(null, this.properties);
                }
                catch (Exception e) {
                    ExceptionUtils.rethrow((Throwable)e);
                    return null;
                }
            };
        }
        return null;
    }

    @ConstructorProperties(value={"tClass", "properties"})
    public PluginCoercible(Class<T> tClass, Properties properties) {
        this.tClass = tClass;
        this.properties = properties;
    }
}

