/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.server.master.client.diagnostic.plugin;

import io.mantisrx.server.master.client.diagnostic.plugin.DiagnosticMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Observable;
import rx.observers.SerializedObserver;
import rx.subjects.PublishSubject;

public class DiagnosticPlugin {
    private static final Logger logger = LoggerFactory.getLogger(DiagnosticPlugin.class);
    private final PublishSubject<DiagnosticMessage> messagePublisher = PublishSubject.create();
    private final SerializedObserver<DiagnosticMessage> messagePublisherSerialized = new SerializedObserver(this.messagePublisher);
    public static final DiagnosticPlugin INSTANCE = new DiagnosticPlugin();

    private DiagnosticPlugin() {
    }

    public void record(DiagnosticMessage message) {
        if (message != null) {
            this.messagePublisherSerialized.onNext((Object)message);
        } else {
            logger.error("RECORDING_NULL_MESSAGE_PROHBIITED");
        }
    }

    public Observable<DiagnosticMessage> getDiagnosticObservable(int maxBackPressureBuffer) {
        return this.messagePublisher.onBackpressureBuffer((long)maxBackPressureBuffer);
    }
}

