/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.server.core;

import java.io.File;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.nio.file.Path;
import javax.annotation.Nullable;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.classloading.ComponentClassLoader;
import org.apache.flink.runtime.rpc.AddressResolution;
import org.apache.flink.runtime.rpc.RpcSystem;
import org.apache.flink.util.FileUtils;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CleanupOnCloseRpcSystem
implements RpcSystem {
    private static final Logger log = LoggerFactory.getLogger(CleanupOnCloseRpcSystem.class);
    private final RpcSystem rpcSystem;
    private final ComponentClassLoader pluginLoader;
    @Nullable
    private final Path tempDirectory;

    public CleanupOnCloseRpcSystem(RpcSystem rpcSystem, ComponentClassLoader pluginLoader, @Nullable Path tempDirectory) {
        this.rpcSystem = (RpcSystem)Preconditions.checkNotNull((Object)rpcSystem);
        this.pluginLoader = (ComponentClassLoader)Preconditions.checkNotNull((Object)pluginLoader);
        this.tempDirectory = tempDirectory;
    }

    public void close() {
        log.info("Closing MantisAkkaRpcSystemLoader.");
        this.rpcSystem.close();
        try {
            this.pluginLoader.close();
        }
        catch (Exception e) {
            log.warn("Could not close RpcSystem classloader.", (Throwable)e);
        }
        if (this.tempDirectory != null) {
            try {
                FileUtils.deleteFileOrDirectory((File)this.tempDirectory.toFile());
            }
            catch (Exception e) {
                log.warn("Could not delete temporary rpc system file {}.", (Object)this.tempDirectory, (Object)e);
            }
        }
    }

    public RpcSystem.RpcServiceBuilder localServiceBuilder(Configuration config) {
        return this.rpcSystem.localServiceBuilder(config);
    }

    public RpcSystem.RpcServiceBuilder remoteServiceBuilder(Configuration configuration, @Nullable String externalAddress, String externalPortRange) {
        return this.rpcSystem.remoteServiceBuilder(configuration, externalAddress, externalPortRange);
    }

    public String getRpcUrl(String hostname, int port, String endpointName, AddressResolution addressResolution, Configuration config) throws UnknownHostException {
        return this.rpcSystem.getRpcUrl(hostname, port, endpointName, addressResolution, config);
    }

    public InetSocketAddress getInetSocketAddressFromRpcUrl(String url) throws Exception {
        return this.rpcSystem.getInetSocketAddressFromRpcUrl(url);
    }

    public long getMaximumMessageSizeInBytes(Configuration config) {
        return this.rpcSystem.getMaximumMessageSizeInBytes(config);
    }
}

