/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.server.master.resourcecluster;

import io.mantisrx.server.master.resourcecluster.ClusterID;
import io.mantisrx.server.master.resourcecluster.TaskExecutorID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.Nullable;

public interface ResourceClusterTaskExecutorMapper {
    @Nullable
    public ClusterID getClusterFor(TaskExecutorID var1);

    public void onTaskExecutorDiscovered(ClusterID var1, TaskExecutorID var2);

    public static ResourceClusterTaskExecutorMapper inMemory() {
        return new ResourceClusterTaskExecutorMapper(){
            private final ConcurrentMap<TaskExecutorID, ClusterID> map = new ConcurrentHashMap<TaskExecutorID, ClusterID>();

            @Override
            public ClusterID getClusterFor(TaskExecutorID taskExecutorID) {
                return (ClusterID)this.map.get(taskExecutorID);
            }

            @Override
            public void onTaskExecutorDiscovered(ClusterID clusterID, TaskExecutorID taskExecutorID) {
                this.map.putIfAbsent(taskExecutorID, clusterID);
            }
        };
    }
}

