/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.server.worker;

import io.mantisrx.common.Ack;
import io.mantisrx.server.core.CacheJobArtifactsRequest;
import io.mantisrx.server.core.ExecuteStageRequest;
import io.mantisrx.server.core.domain.WorkerId;
import java.util.concurrent.CompletableFuture;
import org.apache.flink.runtime.rpc.RpcGateway;

public interface TaskExecutorGateway
extends RpcGateway {
    public CompletableFuture<Ack> submitTask(ExecuteStageRequest var1);

    public CompletableFuture<Ack> cacheJobArtifacts(CacheJobArtifactsRequest var1);

    public CompletableFuture<Ack> cancelTask(WorkerId var1);

    public CompletableFuture<String> requestThreadDump();

    public CompletableFuture<Boolean> isRegistered();

    public static class TaskNotFoundException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public TaskNotFoundException(WorkerId workerId) {
            this(workerId, null);
        }

        public TaskNotFoundException(WorkerId workerId, Throwable cause) {
            super(String.format("Task %s not found", workerId.toString()), cause);
        }
    }

    public static class TaskAlreadyRunningException
    extends Exception {
        private static final long serialVersionUID = 1L;
        private final WorkerId currentlyRunningWorkerTask;

        public TaskAlreadyRunningException(WorkerId workerId) {
            this(workerId, null);
        }

        public TaskAlreadyRunningException(WorkerId workerId, Throwable cause) {
            super(cause);
            this.currentlyRunningWorkerTask = workerId;
        }
    }
}

