/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.server.core;

import io.mantisrx.runtime.codec.JsonType;
import io.mantisrx.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import io.mantisrx.shaded.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.mantisrx.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public class JobAssignmentResult
implements JsonType {
    private final String jobId;
    private final List<Failure> failures;

    @JsonCreator
    @JsonIgnoreProperties(ignoreUnknown=true)
    public JobAssignmentResult(@JsonProperty(value="jobId") String jobId, @JsonProperty(value="failures") List<Failure> failures) {
        this.jobId = jobId;
        this.failures = failures;
    }

    private static boolean failuresIdentical(List<Failure> first, List<Failure> second) {
        if (first == null) {
            return second == null;
        }
        if (second == null) {
            return false;
        }
        if (first.size() != second.size()) {
            return false;
        }
        boolean item = false;
        for (Failure f : first) {
            boolean found = false;
            for (int fi = 0; fi < second.size() && !found; ++fi) {
                if (!f.isIdentical(second.get(fi))) continue;
                found = true;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    public String getJobId() {
        return this.jobId;
    }

    public List<Failure> getFailures() {
        return this.failures;
    }

    public boolean isIdentical(JobAssignmentResult that) {
        if (that == null) {
            return false;
        }
        if (this == that) {
            return true;
        }
        if (!this.jobId.equals(that.jobId)) {
            return false;
        }
        return JobAssignmentResult.failuresIdentical(this.failures, that.failures);
    }

    public static class Failure {
        private int workerNumber;
        private String type;
        private double asking;
        private double used;
        private double available;

        @JsonCreator
        @JsonIgnoreProperties(ignoreUnknown=true)
        public Failure(@JsonProperty(value="workerNumber") int workerNumber, @JsonProperty(value="type") String type, @JsonProperty(value="asking") double asking, @JsonProperty(value="used") double used, @JsonProperty(value="available") double available) {
            this.workerNumber = workerNumber;
            this.type = type;
            this.asking = asking;
            this.used = used;
            this.available = available;
        }

        public int getWorkerNumber() {
            return this.workerNumber;
        }

        public String getType() {
            return this.type;
        }

        public double getAsking() {
            return this.asking;
        }

        public double getUsed() {
            return this.used;
        }

        public double getAvailable() {
            return this.available;
        }

        private boolean isIdentical(Failure that) {
            if (that == null) {
                return false;
            }
            return this.workerNumber == that.workerNumber && this.type.equals(that.type) && this.asking == that.asking && this.used == that.used && this.available == that.available;
        }
    }
}

