/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.server.master.resourcecluster;

import io.mantisrx.common.Ack;
import io.mantisrx.server.core.domain.ArtifactID;
import io.mantisrx.server.core.domain.WorkerId;
import io.mantisrx.server.master.resourcecluster.ClusterID;
import io.mantisrx.server.master.resourcecluster.ContainerSkuID;
import io.mantisrx.server.master.resourcecluster.PagedActiveJobOverview;
import io.mantisrx.server.master.resourcecluster.ResourceClusterGateway;
import io.mantisrx.server.master.resourcecluster.TaskExecutorAllocationRequest;
import io.mantisrx.server.master.resourcecluster.TaskExecutorID;
import io.mantisrx.server.master.resourcecluster.TaskExecutorRegistration;
import io.mantisrx.server.worker.TaskExecutorGateway;
import java.beans.ConstructorProperties;
import java.time.Instant;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;

public interface ResourceCluster
extends ResourceClusterGateway {
    public String getName();

    public CompletableFuture<Ack> initializeTaskExecutor(TaskExecutorID var1, WorkerId var2);

    default public CompletableFuture<List<TaskExecutorID>> getRegisteredTaskExecutors() {
        return this.getRegisteredTaskExecutors(Collections.emptyMap());
    }

    public CompletableFuture<List<TaskExecutorID>> getRegisteredTaskExecutors(Map<String, String> var1);

    default public CompletableFuture<List<TaskExecutorID>> getAvailableTaskExecutors() {
        return this.getAvailableTaskExecutors(Collections.emptyMap());
    }

    public CompletableFuture<List<TaskExecutorID>> getAvailableTaskExecutors(Map<String, String> var1);

    default public CompletableFuture<List<TaskExecutorID>> getBusyTaskExecutors() {
        return this.getBusyTaskExecutors(Collections.emptyMap());
    }

    public CompletableFuture<List<TaskExecutorID>> getBusyTaskExecutors(Map<String, String> var1);

    default public CompletableFuture<List<TaskExecutorID>> getUnregisteredTaskExecutors() {
        return this.getUnregisteredTaskExecutors(Collections.emptyMap());
    }

    public CompletableFuture<List<TaskExecutorID>> getUnregisteredTaskExecutors(Map<String, String> var1);

    public CompletableFuture<ResourceOverview> resourceOverview();

    public CompletableFuture<Ack> addNewJobArtifactsToCache(ClusterID var1, List<ArtifactID> var2);

    public CompletableFuture<Ack> removeJobArtifactsToCache(List<ArtifactID> var1);

    public CompletableFuture<List<ArtifactID>> getJobArtifactsToCache();

    public CompletableFuture<TaskExecutorID> getTaskExecutorFor(TaskExecutorAllocationRequest var1);

    public CompletableFuture<TaskExecutorGateway> getTaskExecutorGateway(TaskExecutorID var1);

    public CompletableFuture<TaskExecutorRegistration> getTaskExecutorInfo(String var1);

    public CompletableFuture<TaskExecutorID> getTaskExecutorAssignedFor(WorkerId var1);

    public CompletableFuture<TaskExecutorRegistration> getTaskExecutorInfo(TaskExecutorID var1);

    public CompletableFuture<TaskExecutorStatus> getTaskExecutorState(TaskExecutorID var1);

    public CompletableFuture<Ack> refreshClusterScalerRuleSet();

    public CompletableFuture<Ack> disableTaskExecutorsFor(Map<String, String> var1, Instant var2, Optional<TaskExecutorID> var3);

    public CompletableFuture<Ack> setScalerStatus(ClusterID var1, ContainerSkuID var2, Boolean var3, Long var4);

    public CompletableFuture<PagedActiveJobOverview> getActiveJobOverview(Optional<Integer> var1, Optional<Integer> var2);

    public CompletableFuture<Map<TaskExecutorID, WorkerId>> getTaskExecutorWorkerMapping();

    public CompletableFuture<Map<TaskExecutorID, WorkerId>> getTaskExecutorWorkerMapping(Map<String, String> var1);

    public static final class TaskExecutorStatus {
        private final TaskExecutorRegistration registration;
        private final boolean registered;
        private final boolean runningTask;
        private final boolean assignedTask;
        private final boolean disabled;
        @Nullable
        private final WorkerId workerId;
        private final long lastHeartbeatInMs;

        @ConstructorProperties(value={"registration", "registered", "runningTask", "assignedTask", "disabled", "workerId", "lastHeartbeatInMs"})
        public TaskExecutorStatus(TaskExecutorRegistration registration, boolean registered, boolean runningTask, boolean assignedTask, boolean disabled, @Nullable WorkerId workerId, long lastHeartbeatInMs) {
            this.registration = registration;
            this.registered = registered;
            this.runningTask = runningTask;
            this.assignedTask = assignedTask;
            this.disabled = disabled;
            this.workerId = workerId;
            this.lastHeartbeatInMs = lastHeartbeatInMs;
        }

        public TaskExecutorRegistration getRegistration() {
            return this.registration;
        }

        public boolean isRegistered() {
            return this.registered;
        }

        public boolean isRunningTask() {
            return this.runningTask;
        }

        public boolean isAssignedTask() {
            return this.assignedTask;
        }

        public boolean isDisabled() {
            return this.disabled;
        }

        @Nullable
        public WorkerId getWorkerId() {
            return this.workerId;
        }

        public long getLastHeartbeatInMs() {
            return this.lastHeartbeatInMs;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TaskExecutorStatus)) {
                return false;
            }
            TaskExecutorStatus other = (TaskExecutorStatus)o;
            if (this.isRegistered() != other.isRegistered()) {
                return false;
            }
            if (this.isRunningTask() != other.isRunningTask()) {
                return false;
            }
            if (this.isAssignedTask() != other.isAssignedTask()) {
                return false;
            }
            if (this.isDisabled() != other.isDisabled()) {
                return false;
            }
            if (this.getLastHeartbeatInMs() != other.getLastHeartbeatInMs()) {
                return false;
            }
            TaskExecutorRegistration this$registration = this.getRegistration();
            TaskExecutorRegistration other$registration = other.getRegistration();
            if (this$registration == null ? other$registration != null : !((Object)this$registration).equals(other$registration)) {
                return false;
            }
            WorkerId this$workerId = this.getWorkerId();
            WorkerId other$workerId = other.getWorkerId();
            return !(this$workerId == null ? other$workerId != null : !((Object)this$workerId).equals(other$workerId));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isRegistered() ? 79 : 97);
            result = result * 59 + (this.isRunningTask() ? 79 : 97);
            result = result * 59 + (this.isAssignedTask() ? 79 : 97);
            result = result * 59 + (this.isDisabled() ? 79 : 97);
            long $lastHeartbeatInMs = this.getLastHeartbeatInMs();
            result = result * 59 + (int)($lastHeartbeatInMs >>> 32 ^ $lastHeartbeatInMs);
            TaskExecutorRegistration $registration = this.getRegistration();
            result = result * 59 + ($registration == null ? 43 : ((Object)$registration).hashCode());
            WorkerId $workerId = this.getWorkerId();
            result = result * 59 + ($workerId == null ? 43 : ((Object)$workerId).hashCode());
            return result;
        }

        public String toString() {
            return "ResourceCluster.TaskExecutorStatus(registration=" + this.getRegistration() + ", registered=" + this.isRegistered() + ", runningTask=" + this.isRunningTask() + ", assignedTask=" + this.isAssignedTask() + ", disabled=" + this.isDisabled() + ", workerId=" + this.getWorkerId() + ", lastHeartbeatInMs=" + this.getLastHeartbeatInMs() + ")";
        }
    }

    public static final class ResourceOverview {
        private final long numRegisteredTaskExecutors;
        private final long numAvailableTaskExecutors;
        private final long numOccupiedTaskExecutors;
        private final long numAssignedTaskExecutors;
        private final long numDisabledTaskExecutors;

        @ConstructorProperties(value={"numRegisteredTaskExecutors", "numAvailableTaskExecutors", "numOccupiedTaskExecutors", "numAssignedTaskExecutors", "numDisabledTaskExecutors"})
        public ResourceOverview(long numRegisteredTaskExecutors, long numAvailableTaskExecutors, long numOccupiedTaskExecutors, long numAssignedTaskExecutors, long numDisabledTaskExecutors) {
            this.numRegisteredTaskExecutors = numRegisteredTaskExecutors;
            this.numAvailableTaskExecutors = numAvailableTaskExecutors;
            this.numOccupiedTaskExecutors = numOccupiedTaskExecutors;
            this.numAssignedTaskExecutors = numAssignedTaskExecutors;
            this.numDisabledTaskExecutors = numDisabledTaskExecutors;
        }

        public long getNumRegisteredTaskExecutors() {
            return this.numRegisteredTaskExecutors;
        }

        public long getNumAvailableTaskExecutors() {
            return this.numAvailableTaskExecutors;
        }

        public long getNumOccupiedTaskExecutors() {
            return this.numOccupiedTaskExecutors;
        }

        public long getNumAssignedTaskExecutors() {
            return this.numAssignedTaskExecutors;
        }

        public long getNumDisabledTaskExecutors() {
            return this.numDisabledTaskExecutors;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ResourceOverview)) {
                return false;
            }
            ResourceOverview other = (ResourceOverview)o;
            if (this.getNumRegisteredTaskExecutors() != other.getNumRegisteredTaskExecutors()) {
                return false;
            }
            if (this.getNumAvailableTaskExecutors() != other.getNumAvailableTaskExecutors()) {
                return false;
            }
            if (this.getNumOccupiedTaskExecutors() != other.getNumOccupiedTaskExecutors()) {
                return false;
            }
            if (this.getNumAssignedTaskExecutors() != other.getNumAssignedTaskExecutors()) {
                return false;
            }
            return this.getNumDisabledTaskExecutors() == other.getNumDisabledTaskExecutors();
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $numRegisteredTaskExecutors = this.getNumRegisteredTaskExecutors();
            result = result * 59 + (int)($numRegisteredTaskExecutors >>> 32 ^ $numRegisteredTaskExecutors);
            long $numAvailableTaskExecutors = this.getNumAvailableTaskExecutors();
            result = result * 59 + (int)($numAvailableTaskExecutors >>> 32 ^ $numAvailableTaskExecutors);
            long $numOccupiedTaskExecutors = this.getNumOccupiedTaskExecutors();
            result = result * 59 + (int)($numOccupiedTaskExecutors >>> 32 ^ $numOccupiedTaskExecutors);
            long $numAssignedTaskExecutors = this.getNumAssignedTaskExecutors();
            result = result * 59 + (int)($numAssignedTaskExecutors >>> 32 ^ $numAssignedTaskExecutors);
            long $numDisabledTaskExecutors = this.getNumDisabledTaskExecutors();
            result = result * 59 + (int)($numDisabledTaskExecutors >>> 32 ^ $numDisabledTaskExecutors);
            return result;
        }

        public String toString() {
            return "ResourceCluster.ResourceOverview(numRegisteredTaskExecutors=" + this.getNumRegisteredTaskExecutors() + ", numAvailableTaskExecutors=" + this.getNumAvailableTaskExecutors() + ", numOccupiedTaskExecutors=" + this.getNumOccupiedTaskExecutors() + ", numAssignedTaskExecutors=" + this.getNumAssignedTaskExecutors() + ", numDisabledTaskExecutors=" + this.getNumDisabledTaskExecutors() + ")";
        }
    }

    public static class ConnectionFailedException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public ConnectionFailedException(Throwable cause) {
            super(cause);
        }
    }

    public static class NoResourceAvailableException
    extends Exception {
        public NoResourceAvailableException(String message) {
            super(message);
        }
    }
}

