/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.server.core.stats;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;

public class SimpleStats {
    private final int maxDataPoints;
    private final ArrayList<Double> dataPoints;

    public SimpleStats(int maxDataPoints) {
        this.maxDataPoints = maxDataPoints;
        this.dataPoints = new ArrayList();
    }

    public SimpleStats(Collection<Double> data) {
        this.maxDataPoints = data.size();
        this.dataPoints = new ArrayList<Double>(data);
    }

    public static void main(String[] args) {
        SimpleStats simpleStats = new SimpleStats(5);
        simpleStats.add(4.0);
        for (int i = 1; i < 4; ++i) {
            simpleStats.add(0.0);
        }
        simpleStats.add(10.0);
        System.out.println(String.format("thresh=%8.2f", simpleStats.getOutlierThreshold()));
    }

    public void add(double d) {
        if (this.dataPoints.size() == this.maxDataPoints) {
            this.dataPoints.remove(0);
        }
        this.dataPoints.add(d);
    }

    public double getOutlierThreshold() {
        if (this.dataPoints.size() <= 2) {
            return this.twoPointsResults();
        }
        Object[] data = this.dataPoints.toArray(new Double[0]);
        Arrays.sort(data);
        double total = 0.0;
        Object[] objectArray = data;
        int n = objectArray.length;
        for (int i = 0; i < n; ++i) {
            double d = (Double)objectArray[i];
            total += d;
        }
        if ((Double)data[data.length - 1] / total > 0.75) {
            return (Double)data[data.length - 2];
        }
        if (this.dataPoints.size() == 3) {
            return this.threePointsResults((Double[])data);
        }
        if (this.dataPoints.size() == 4) {
            return this.fourPointsResults((Double[])data);
        }
        double q1 = (Double)data[(int)Math.round((double)data.length / 4.0)];
        double q3 = (Double)data[(int)Math.floor((double)data.length * 3.0 / 4.0)];
        return this.getThresh(q1, q3);
    }

    private double fourPointsResults(Double[] data) {
        return this.getThresh(data[1], data[2]);
    }

    private double getThresh(double q1, double q3) {
        return q3 + q3 - q1;
    }

    private double threePointsResults(Double[] data) {
        double q1 = (data[0] + data[1]) / 2.0;
        double q3 = (data[1] + data[2]) / 2.0;
        return this.getThresh(q1, q3);
    }

    private double twoPointsResults() {
        return this.dataPoints.isEmpty() ? 0.0 : (this.dataPoints.get(0) == 0.0 ? 0.0 : this.dataPoints.get(this.dataPoints.size() - 1));
    }

    public boolean isSufficientData() {
        return this.dataPoints.size() > 3;
    }

    public String toString() {
        return "SimpleStats{maxDataPoints=" + this.maxDataPoints + ", dataPoints=" + this.dataPoints + '}';
    }
}

