/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.mantis.remote.observable;

import io.mantisrx.common.codec.Decoder;
import io.reactivex.mantis.remote.observable.ConnectToConfig;
import java.util.HashMap;
import java.util.Map;
import rx.functions.Action0;
import rx.functions.Action3;
import rx.subjects.PublishSubject;

public class ConnectToGroupedObservable<K, V>
extends ConnectToConfig {
    private Decoder<K> keyDecoder;
    private Decoder<V> valueDecoder;
    private Action3<K, V, Throwable> deocdingErrorHandler;

    ConnectToGroupedObservable(Builder<K, V> builder) {
        super(((Builder)builder).host, ((Builder)builder).port, ((Builder)builder).name, ((Builder)builder).subscribeParameters, ((Builder)builder).subscribeAttempts, ((Builder)builder).suppressDecodingErrors, ((Builder)builder).connectionDisconnectCallback, (PublishSubject<Integer>)((Builder)builder).closeTrigger);
        this.keyDecoder = ((Builder)builder).keyDecoder;
        this.valueDecoder = ((Builder)builder).valueDecoder;
        this.deocdingErrorHandler = ((Builder)builder).deocdingErrorHandler;
    }

    public Decoder<K> getKeyDecoder() {
        return this.keyDecoder;
    }

    public Decoder<V> getValueDecoder() {
        return this.valueDecoder;
    }

    public Action3<K, V, Throwable> getDeocdingErrorHandler() {
        return this.deocdingErrorHandler;
    }

    public static class Builder<K, V> {
        private String host;
        private int port;
        private String name;
        private Decoder<K> keyDecoder;
        private Decoder<V> valueDecoder;
        private Map<String, String> subscribeParameters = new HashMap<String, String>();
        private int subscribeAttempts = 3;
        private Action3<K, V, Throwable> deocdingErrorHandler = new Action3<K, V, Throwable>(this){
            final /* synthetic */ Builder this$0;
            {
                this.this$0 = this$0;
            }

            public void call(K key, V value, Throwable t2) {
                t2.printStackTrace();
            }
        };
        private boolean suppressDecodingErrors = false;
        private Action0 connectionDisconnectCallback = new Action0(this){
            final /* synthetic */ Builder this$0;
            {
                this.this$0 = this$0;
            }

            public void call() {
            }
        };
        private PublishSubject<Integer> closeTrigger = PublishSubject.create();

        public Builder() {
        }

        public Builder(Builder<K, V> config) {
            this.host = config.host;
            this.port = config.port;
            this.name = config.name;
            this.keyDecoder = config.keyDecoder;
            this.valueDecoder = config.valueDecoder;
            this.subscribeParameters.putAll(config.subscribeParameters);
            this.subscribeAttempts = config.subscribeAttempts;
            this.deocdingErrorHandler = config.deocdingErrorHandler;
            this.suppressDecodingErrors = config.suppressDecodingErrors;
        }

        public Builder<K, V> host(String host) {
            this.host = host;
            return this;
        }

        public Builder<K, V> port(int port) {
            this.port = port;
            return this;
        }

        public Builder<K, V> closeTrigger(PublishSubject<Integer> closeTrigger) {
            this.closeTrigger = closeTrigger;
            return this;
        }

        public Builder<K, V> connectionDisconnectCallback(Action0 connectionDisconnectCallback) {
            this.connectionDisconnectCallback = connectionDisconnectCallback;
            return this;
        }

        public Builder<K, V> deocdingErrorHandler(Action3<K, V, Throwable> handler, boolean suppressDecodingErrors) {
            this.deocdingErrorHandler = handler;
            this.suppressDecodingErrors = suppressDecodingErrors;
            return this;
        }

        public Builder<K, V> name(String name) {
            this.name = name;
            this.subscribeParameters.put("groupId", name);
            return this;
        }

        public Builder<K, V> slotId(String slotId) {
            this.subscribeParameters.put("slotId", slotId);
            return this;
        }

        public Builder<K, V> keyDecoder(Decoder<K> keyDecoder) {
            this.keyDecoder = keyDecoder;
            return this;
        }

        public Builder<K, V> valueDecoder(Decoder<V> valueDecoder) {
            this.valueDecoder = valueDecoder;
            return this;
        }

        public Builder<K, V> subscribeParameters(Map<String, String> subscribeParameters) {
            this.subscribeParameters.putAll(subscribeParameters);
            return this;
        }

        public Builder<K, V> subscribeAttempts(int subscribeAttempts) {
            this.subscribeAttempts = subscribeAttempts;
            return this;
        }

        public ConnectToGroupedObservable<K, V> build() {
            return new ConnectToGroupedObservable(this);
        }
    }
}

