/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.shaded.com.fasterxml.jackson.module.afterburner.ser;

import io.mantisrx.shaded.com.fasterxml.jackson.databind.introspect.AnnotatedField;
import io.mantisrx.shaded.com.fasterxml.jackson.databind.ser.BeanPropertyWriter;
import io.mantisrx.shaded.com.fasterxml.jackson.module.afterburner.asm.ClassWriter;
import io.mantisrx.shaded.com.fasterxml.jackson.module.afterburner.asm.Label;
import io.mantisrx.shaded.com.fasterxml.jackson.module.afterburner.asm.MethodVisitor;
import io.mantisrx.shaded.com.fasterxml.jackson.module.afterburner.asm.Type;
import io.mantisrx.shaded.com.fasterxml.jackson.module.afterburner.ser.BeanPropertyAccessor;
import io.mantisrx.shaded.com.fasterxml.jackson.module.afterburner.ser.BooleanFieldPropertyWriter;
import io.mantisrx.shaded.com.fasterxml.jackson.module.afterburner.ser.BooleanMethodPropertyWriter;
import io.mantisrx.shaded.com.fasterxml.jackson.module.afterburner.ser.IntFieldPropertyWriter;
import io.mantisrx.shaded.com.fasterxml.jackson.module.afterburner.ser.IntMethodPropertyWriter;
import io.mantisrx.shaded.com.fasterxml.jackson.module.afterburner.ser.LongFieldPropertyWriter;
import io.mantisrx.shaded.com.fasterxml.jackson.module.afterburner.ser.LongMethodPropertyWriter;
import io.mantisrx.shaded.com.fasterxml.jackson.module.afterburner.ser.ObjectFieldPropertyWriter;
import io.mantisrx.shaded.com.fasterxml.jackson.module.afterburner.ser.ObjectMethodPropertyWriter;
import io.mantisrx.shaded.com.fasterxml.jackson.module.afterburner.ser.OptimizedBeanPropertyWriter;
import io.mantisrx.shaded.com.fasterxml.jackson.module.afterburner.ser.StringFieldPropertyWriter;
import io.mantisrx.shaded.com.fasterxml.jackson.module.afterburner.ser.StringMethodPropertyWriter;
import io.mantisrx.shaded.com.fasterxml.jackson.module.afterburner.util.ClassName;
import io.mantisrx.shaded.com.fasterxml.jackson.module.afterburner.util.DynamicPropertyAccessorBase;
import io.mantisrx.shaded.com.fasterxml.jackson.module.afterburner.util.MyClassLoader;
import java.lang.reflect.Method;
import java.util.LinkedList;
import java.util.List;

public class PropertyAccessorCollector
extends DynamicPropertyAccessorBase {
    private static final Type STRING_TYPE = Type.getType(String.class);
    private static final Type OBJECT_TYPE = Type.getType(Object.class);
    private final List<BooleanMethodPropertyWriter> _booleanGetters = new LinkedList<BooleanMethodPropertyWriter>();
    private final List<IntMethodPropertyWriter> _intGetters = new LinkedList<IntMethodPropertyWriter>();
    private final List<LongMethodPropertyWriter> _longGetters = new LinkedList<LongMethodPropertyWriter>();
    private final List<StringMethodPropertyWriter> _stringGetters = new LinkedList<StringMethodPropertyWriter>();
    private final List<ObjectMethodPropertyWriter> _objectGetters = new LinkedList<ObjectMethodPropertyWriter>();
    private final List<BooleanFieldPropertyWriter> _booleanFields = new LinkedList<BooleanFieldPropertyWriter>();
    private final List<IntFieldPropertyWriter> _intFields = new LinkedList<IntFieldPropertyWriter>();
    private final List<LongFieldPropertyWriter> _longFields = new LinkedList<LongFieldPropertyWriter>();
    private final List<StringFieldPropertyWriter> _stringFields = new LinkedList<StringFieldPropertyWriter>();
    private final List<ObjectFieldPropertyWriter> _objectFields = new LinkedList<ObjectFieldPropertyWriter>();
    private final Class<?> beanClass;
    private final String beanClassName;

    public PropertyAccessorCollector(Class<?> beanClass) {
        this.beanClass = beanClass;
        this.beanClassName = Type.getInternalName(beanClass);
    }

    public BooleanMethodPropertyWriter addBooleanGetter(BeanPropertyWriter bpw) {
        return this._add(this._booleanGetters, new BooleanMethodPropertyWriter(bpw, null, this._booleanGetters.size(), null));
    }

    public IntMethodPropertyWriter addIntGetter(BeanPropertyWriter bpw) {
        return this._add(this._intGetters, new IntMethodPropertyWriter(bpw, null, this._intGetters.size(), null));
    }

    public LongMethodPropertyWriter addLongGetter(BeanPropertyWriter bpw) {
        return this._add(this._longGetters, new LongMethodPropertyWriter(bpw, null, this._longGetters.size(), null));
    }

    public StringMethodPropertyWriter addStringGetter(BeanPropertyWriter bpw) {
        return this._add(this._stringGetters, new StringMethodPropertyWriter(bpw, null, this._stringGetters.size(), null));
    }

    public ObjectMethodPropertyWriter addObjectGetter(BeanPropertyWriter bpw) {
        return this._add(this._objectGetters, new ObjectMethodPropertyWriter(bpw, null, this._objectGetters.size(), null));
    }

    public BooleanFieldPropertyWriter addBooleanField(BeanPropertyWriter bpw) {
        return this._add(this._booleanFields, new BooleanFieldPropertyWriter(bpw, null, this._booleanFields.size(), null));
    }

    public IntFieldPropertyWriter addIntField(BeanPropertyWriter bpw) {
        return this._add(this._intFields, new IntFieldPropertyWriter(bpw, null, this._intFields.size(), null));
    }

    public LongFieldPropertyWriter addLongField(BeanPropertyWriter bpw) {
        return this._add(this._longFields, new LongFieldPropertyWriter(bpw, null, this._longFields.size(), null));
    }

    public StringFieldPropertyWriter addStringField(BeanPropertyWriter bpw) {
        return this._add(this._stringFields, new StringFieldPropertyWriter(bpw, null, this._stringFields.size(), null));
    }

    public ObjectFieldPropertyWriter addObjectField(BeanPropertyWriter bpw) {
        return this._add(this._objectFields, new ObjectFieldPropertyWriter(bpw, null, this._objectFields.size(), null));
    }

    public BeanPropertyAccessor findAccessor(MyClassLoader classLoader) {
        if (classLoader == null) {
            classLoader = new MyClassLoader(this.beanClass.getClassLoader(), true);
        }
        ClassName baseName = ClassName.constructFor(this.beanClass, "$Access4JacksonSerializer");
        Class<?> accessorClass = this.generateAccessorClass(classLoader, baseName);
        try {
            return (BeanPropertyAccessor)accessorClass.newInstance();
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to generate accessor class '" + accessorClass.getName() + "': " + e.getMessage(), e);
        }
    }

    public Class<?> generateAccessorClass(MyClassLoader classLoader, ClassName baseName) {
        ClassWriter cw = new ClassWriter(1);
        String superClass = PropertyAccessorCollector.internalClassName(BeanPropertyAccessor.class.getName());
        String tmpClassName = baseName.getSlashedTemplate();
        cw.visit(50, 49, tmpClassName, null, superClass, null);
        cw.visitSource(baseName.getSourceFilename(), null);
        MethodVisitor mv = cw.visitMethod(1, "<init>", "()V", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, superClass, "<init>", "()V", false);
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
        if (!this._intFields.isEmpty()) {
            this._addFields(cw, this._intFields, "intField", Type.INT_TYPE, 172);
        }
        if (!this._longFields.isEmpty()) {
            this._addFields(cw, this._longFields, "longField", Type.LONG_TYPE, 173);
        }
        if (!this._stringFields.isEmpty()) {
            this._addFields(cw, this._stringFields, "stringField", STRING_TYPE, 176);
        }
        if (!this._objectFields.isEmpty()) {
            this._addFields(cw, this._objectFields, "objectField", OBJECT_TYPE, 176);
        }
        if (!this._booleanFields.isEmpty()) {
            this._addFields(cw, this._booleanFields, "booleanField", Type.BOOLEAN_TYPE, 172);
        }
        if (!this._intGetters.isEmpty()) {
            this._addGetters(cw, this._intGetters, "intGetter", Type.INT_TYPE, 172);
        }
        if (!this._longGetters.isEmpty()) {
            this._addGetters(cw, this._longGetters, "longGetter", Type.LONG_TYPE, 173);
        }
        if (!this._stringGetters.isEmpty()) {
            this._addGetters(cw, this._stringGetters, "stringGetter", STRING_TYPE, 176);
        }
        if (!this._objectGetters.isEmpty()) {
            this._addGetters(cw, this._objectGetters, "objectGetter", OBJECT_TYPE, 176);
        }
        if (!this._booleanGetters.isEmpty()) {
            this._addGetters(cw, this._booleanGetters, "booleanGetter", Type.BOOLEAN_TYPE, 172);
        }
        cw.visitEnd();
        byte[] bytecode = cw.toByteArray();
        baseName.assignChecksum(bytecode);
        try {
            return classLoader.loadClass(baseName.getDottedName());
        }
        catch (ClassNotFoundException classNotFoundException) {
            return classLoader.loadAndResolve(baseName, bytecode);
        }
    }

    private <T extends OptimizedBeanPropertyWriter<T>> void _addGetters(ClassWriter cw, List<T> props, String methodName, Type returnType, int returnOpcode) {
        MethodVisitor mv = cw.visitMethod(1, methodName, "(Ljava/lang/Object;I)" + returnType, null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 1);
        mv.visitTypeInsn(192, this.beanClassName);
        mv.visitVarInsn(58, 3);
        switch (props.size()) {
            case 1: {
                this._addSingleGetter(mv, (OptimizedBeanPropertyWriter)props.get(0), returnOpcode);
                break;
            }
            case 2: 
            case 3: {
                this._addGettersUsingIf(mv, props, returnOpcode);
                break;
            }
            default: {
                this._addGettersUsingSwitch(mv, props, returnOpcode);
            }
        }
        PropertyAccessorCollector.generateException(mv, this.beanClassName, props.size());
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    private <T extends OptimizedBeanPropertyWriter<T>> void _addFields(ClassWriter cw, List<T> props, String methodName, Type returnType, int returnOpcode) {
        MethodVisitor mv = cw.visitMethod(1, methodName, "(Ljava/lang/Object;I)" + returnType, null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 1);
        mv.visitTypeInsn(192, this.beanClassName);
        mv.visitVarInsn(58, 3);
        switch (props.size()) {
            case 1: {
                this._addSingleField(mv, (OptimizedBeanPropertyWriter)props.get(0), returnOpcode);
                break;
            }
            case 2: 
            case 3: {
                this._addFieldsUsingIf(mv, props, returnOpcode);
                break;
            }
            default: {
                this._addFieldsUsingSwitch(mv, props, returnOpcode);
            }
        }
        PropertyAccessorCollector.generateException(mv, this.beanClassName, props.size());
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    private void _addSingleGetter(MethodVisitor mv, OptimizedBeanPropertyWriter<?> prop, int returnOpcode) {
        mv.visitVarInsn(21, 2);
        mv.visitVarInsn(25, 3);
        int invokeInsn = this.beanClass.isInterface() ? 185 : 182;
        Method method = (Method)prop.getMember().getMember();
        mv.visitMethodInsn(invokeInsn, this.beanClassName, method.getName(), Type.getMethodDescriptor(method), this.beanClass.isInterface());
        mv.visitInsn(returnOpcode);
    }

    private <T extends OptimizedBeanPropertyWriter<T>> void _addGettersUsingIf(MethodVisitor mv, List<T> props, int returnOpcode) {
        mv.visitVarInsn(21, 2);
        Label next = new Label();
        mv.visitJumpInsn(154, next);
        mv.visitVarInsn(25, 3);
        int invokeInsn = this.beanClass.isInterface() ? 185 : 182;
        Method method = (Method)((OptimizedBeanPropertyWriter)props.get(0)).getMember().getMember();
        mv.visitMethodInsn(invokeInsn, this.beanClassName, method.getName(), Type.getMethodDescriptor(method), this.beanClass.isInterface());
        mv.visitInsn(returnOpcode);
        int end = props.size() - 1;
        for (int i = 1; i <= end; ++i) {
            mv.visitLabel(next);
            if (i < end) {
                next = new Label();
                mv.visitVarInsn(21, 2);
                mv.visitInsn(ALL_INT_CONSTS[i]);
                mv.visitJumpInsn(160, next);
            }
            mv.visitVarInsn(25, 3);
            method = (Method)((OptimizedBeanPropertyWriter)props.get(i)).getMember().getMember();
            mv.visitMethodInsn(invokeInsn, this.beanClassName, method.getName(), Type.getMethodDescriptor(method), this.beanClass.isInterface());
            mv.visitInsn(returnOpcode);
        }
    }

    private <T extends OptimizedBeanPropertyWriter<T>> void _addGettersUsingSwitch(MethodVisitor mv, List<T> props, int returnOpcode) {
        mv.visitVarInsn(21, 2);
        Label[] labels = new Label[props.size()];
        int len = labels.length;
        for (int i = 0; i < len; ++i) {
            labels[i] = new Label();
        }
        Label defaultLabel = new Label();
        mv.visitTableSwitchInsn(0, labels.length - 1, defaultLabel, labels);
        int invokeInsn = this.beanClass.isInterface() ? 185 : 182;
        int len2 = labels.length;
        for (int i = 0; i < len2; ++i) {
            mv.visitLabel(labels[i]);
            mv.visitVarInsn(25, 3);
            Method method = (Method)((OptimizedBeanPropertyWriter)props.get(i)).getMember().getMember();
            mv.visitMethodInsn(invokeInsn, this.beanClassName, method.getName(), Type.getMethodDescriptor(method), this.beanClass.isInterface());
            mv.visitInsn(returnOpcode);
        }
        mv.visitLabel(defaultLabel);
    }

    private void _addSingleField(MethodVisitor mv, OptimizedBeanPropertyWriter<?> prop, int returnOpcode) {
        mv.visitVarInsn(21, 2);
        mv.visitVarInsn(25, 3);
        AnnotatedField field = (AnnotatedField)prop.getMember();
        mv.visitFieldInsn(180, this.beanClassName, field.getName(), Type.getDescriptor(field.getRawType()));
        mv.visitInsn(returnOpcode);
    }

    private <T extends OptimizedBeanPropertyWriter<T>> void _addFieldsUsingIf(MethodVisitor mv, List<T> props, int returnOpcode) {
        mv.visitVarInsn(21, 2);
        Label next = new Label();
        mv.visitJumpInsn(154, next);
        mv.visitVarInsn(25, 3);
        AnnotatedField field = (AnnotatedField)((OptimizedBeanPropertyWriter)props.get(0)).getMember();
        mv.visitFieldInsn(180, this.beanClassName, field.getName(), Type.getDescriptor(field.getRawType()));
        mv.visitInsn(returnOpcode);
        int end = props.size() - 1;
        for (int i = 1; i <= end; ++i) {
            mv.visitLabel(next);
            if (i < end) {
                next = new Label();
                mv.visitVarInsn(21, 2);
                mv.visitInsn(ALL_INT_CONSTS[i]);
                mv.visitJumpInsn(160, next);
            }
            mv.visitVarInsn(25, 3);
            field = (AnnotatedField)((OptimizedBeanPropertyWriter)props.get(i)).getMember();
            mv.visitFieldInsn(180, this.beanClassName, field.getName(), Type.getDescriptor(field.getRawType()));
            mv.visitInsn(returnOpcode);
        }
    }

    private <T extends OptimizedBeanPropertyWriter<T>> void _addFieldsUsingSwitch(MethodVisitor mv, List<T> props, int returnOpcode) {
        mv.visitVarInsn(21, 2);
        Label[] labels = new Label[props.size()];
        int len = labels.length;
        for (int i = 0; i < len; ++i) {
            labels[i] = new Label();
        }
        Label defaultLabel = new Label();
        mv.visitTableSwitchInsn(0, labels.length - 1, defaultLabel, labels);
        int len2 = labels.length;
        for (int i = 0; i < len2; ++i) {
            mv.visitLabel(labels[i]);
            mv.visitVarInsn(25, 3);
            AnnotatedField field = (AnnotatedField)((OptimizedBeanPropertyWriter)props.get(i)).getMember();
            mv.visitFieldInsn(180, this.beanClassName, field.getName(), Type.getDescriptor(field.getRawType()));
            mv.visitInsn(returnOpcode);
        }
        mv.visitLabel(defaultLabel);
    }
}

