/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.shaded.io.vavr.jackson.datatype.deserialize;

import io.mantisrx.shaded.com.fasterxml.jackson.databind.DeserializationContext;
import io.mantisrx.shaded.com.fasterxml.jackson.databind.JavaType;
import io.mantisrx.shaded.com.fasterxml.jackson.databind.JsonDeserializer;
import io.mantisrx.shaded.com.fasterxml.jackson.databind.JsonMappingException;
import io.mantisrx.shaded.com.fasterxml.jackson.databind.KeyDeserializer;
import io.mantisrx.shaded.com.fasterxml.jackson.databind.deser.ResolvableDeserializer;
import io.mantisrx.shaded.com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import io.mantisrx.shaded.com.fasterxml.jackson.databind.type.MapLikeType;
import java.util.Comparator;

abstract class MaplikeDeserializer<T>
extends StdDeserializer<T>
implements ResolvableDeserializer {
    private static final long serialVersionUID = 1L;
    final MapLikeType javaType;
    Comparator<Object> keyComparator;
    KeyDeserializer keyDeserializer;
    JsonDeserializer<?> valueDeserializer;

    MaplikeDeserializer(JavaType valueType) {
        super(valueType);
        this.javaType = (MapLikeType)valueType;
    }

    @Override
    public void resolve(DeserializationContext ctxt) throws JsonMappingException {
        JavaType keyType = this.javaType.getKeyType();
        this.keyComparator = keyType.getRawClass().isAssignableFrom(Comparable.class) ? (o1, o2) -> ((Comparable)o1).compareTo(o2) : (o1, o2) -> o1.toString().compareTo(o2.toString());
        this.keyDeserializer = ctxt.findKeyDeserializer(keyType, null);
        this.valueDeserializer = ctxt.findRootValueDeserializer(this.javaType.getContentType());
    }
}

