/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.shaded.io.vavr.jackson.datatype.serialize;

import io.mantisrx.shaded.com.fasterxml.jackson.core.JsonGenerator;
import io.mantisrx.shaded.com.fasterxml.jackson.databind.JavaType;
import io.mantisrx.shaded.com.fasterxml.jackson.databind.JsonSerializer;
import io.mantisrx.shaded.com.fasterxml.jackson.databind.SerializerProvider;
import io.mantisrx.shaded.com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import io.mantisrx.shaded.com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.util.List;

abstract class HListSerializer<T>
extends StdSerializer<T> {
    private static final long serialVersionUID = 1L;
    private final JavaType type;

    HListSerializer(JavaType type) {
        super(type);
        this.type = type;
    }

    void write(Object val, int containedTypeIndex, JsonGenerator gen, SerializerProvider provider) throws IOException {
        if (val != null) {
            if (this.type.containedTypeCount() > containedTypeIndex) {
                JsonSerializer<Object> ser;
                JavaType containedType = this.type.containedType(containedTypeIndex);
                if (containedType != null && containedType.hasGenericTypes()) {
                    List<JavaType> types = containedType.getBindings().getTypeParameters();
                    JavaType[] generics = new JavaType[types.size()];
                    for (int i = 0; i < types.size(); ++i) {
                        generics[i] = types.get(i);
                    }
                    JavaType adjusted = provider.getTypeFactory().constructSimpleType(val.getClass(), generics);
                    ser = provider.findTypedValueSerializer(adjusted, true, null);
                } else {
                    ser = provider.findTypedValueSerializer(val.getClass(), true, null);
                }
                ser.serialize(val, gen, provider);
            } else {
                gen.writeObject(val);
            }
        } else {
            gen.writeNull();
        }
    }

    @Override
    public void serializeWithType(T value, JsonGenerator gen, SerializerProvider serializers, TypeSerializer typeSer) throws IOException {
        typeSer.writeTypePrefixForScalar(value, gen);
        this.serialize(value, gen, serializers);
        typeSer.writeTypeSuffixForScalar(value, gen);
    }
}

